package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAssetsResponse(
    assetSummaries: Iterable[zio.aws.iotsitewise.model.AssetSummary],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.ListAssetsResponse = {
    import ListAssetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.ListAssetsResponse
      .builder()
      .assetSummaries(assetSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.ListAssetsResponse.ReadOnly =
    zio.aws.iotsitewise.model.ListAssetsResponse.wrap(buildAwsValue())
}
object ListAssetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.ListAssetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.ListAssetsResponse =
      zio.aws.iotsitewise.model.ListAssetsResponse(
        assetSummaries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def assetSummaries: List[zio.aws.iotsitewise.model.AssetSummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def getAssetSummaries: ZIO[Any, Nothing, List[
      zio.aws.iotsitewise.model.AssetSummary.ReadOnly
    ]] = ZIO.succeed(assetSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListAssetsResponse
  ) extends zio.aws.iotsitewise.model.ListAssetsResponse.ReadOnly {
    override val assetSummaries
        : List[zio.aws.iotsitewise.model.AssetSummary.ReadOnly] = impl
      .assetSummaries()
      .asScala
      .map { item =>
        zio.aws.iotsitewise.model.AssetSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotsitewise.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListAssetsResponse
  ): zio.aws.iotsitewise.model.ListAssetsResponse.ReadOnly = new Wrapper(impl)
}
