package zio.aws.iotsitewise.model
import scala.jdk.CollectionConverters._
sealed trait JobStatus {
  def unwrap: software.amazon.awssdk.services.iotsitewise.model.JobStatus
}
object JobStatus {
  def wrap(
      value: software.amazon.awssdk.services.iotsitewise.model.JobStatus
  ): zio.aws.iotsitewise.model.JobStatus = value match {
    case software.amazon.awssdk.services.iotsitewise.model.JobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotsitewise.model.JobStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.iotsitewise.model.JobStatus.CANCELLED =>
      val r = CANCELLED
      r
    case software.amazon.awssdk.services.iotsitewise.model.JobStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.iotsitewise.model.JobStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.iotsitewise.model.JobStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.iotsitewise.model.JobStatus.COMPLETED_WITH_FAILURES =>
      val r = COMPLETED_WITH_FAILURES
      r
  }
  case object unknownToSdkVersion extends zio.aws.iotsitewise.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.JobStatus =
      software.amazon.awssdk.services.iotsitewise.model.JobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.iotsitewise.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.JobStatus =
      software.amazon.awssdk.services.iotsitewise.model.JobStatus.PENDING
  }
  case object CANCELLED extends zio.aws.iotsitewise.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.JobStatus =
      software.amazon.awssdk.services.iotsitewise.model.JobStatus.CANCELLED
  }
  case object RUNNING extends zio.aws.iotsitewise.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.JobStatus =
      software.amazon.awssdk.services.iotsitewise.model.JobStatus.RUNNING
  }
  case object COMPLETED extends zio.aws.iotsitewise.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.JobStatus =
      software.amazon.awssdk.services.iotsitewise.model.JobStatus.COMPLETED
  }
  case object FAILED extends zio.aws.iotsitewise.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.JobStatus =
      software.amazon.awssdk.services.iotsitewise.model.JobStatus.FAILED
  }
  case object COMPLETED_WITH_FAILURES
      extends zio.aws.iotsitewise.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.JobStatus =
      software.amazon.awssdk.services.iotsitewise.model.JobStatus.COMPLETED_WITH_FAILURES
  }
}
