package zio.aws.iotsitewise.model
import scala.jdk.CollectionConverters._
sealed trait Quality {
  def unwrap: software.amazon.awssdk.services.iotsitewise.model.Quality
}
object Quality {
  def wrap(
      value: software.amazon.awssdk.services.iotsitewise.model.Quality
  ): zio.aws.iotsitewise.model.Quality = value match {
    case software.amazon.awssdk.services.iotsitewise.model.Quality.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotsitewise.model.Quality.GOOD =>
      val r = GOOD
      r
    case software.amazon.awssdk.services.iotsitewise.model.Quality.BAD =>
      val r = BAD
      r
    case software.amazon.awssdk.services.iotsitewise.model.Quality.UNCERTAIN =>
      val r = UNCERTAIN
      r
  }
  case object unknownToSdkVersion extends zio.aws.iotsitewise.model.Quality {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.Quality =
      software.amazon.awssdk.services.iotsitewise.model.Quality.UNKNOWN_TO_SDK_VERSION
  }
  case object GOOD extends zio.aws.iotsitewise.model.Quality {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.Quality =
      software.amazon.awssdk.services.iotsitewise.model.Quality.GOOD
  }
  case object BAD extends zio.aws.iotsitewise.model.Quality {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.Quality =
      software.amazon.awssdk.services.iotsitewise.model.Quality.BAD
  }
  case object UNCERTAIN extends zio.aws.iotsitewise.model.Quality {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.Quality =
      software.amazon.awssdk.services.iotsitewise.model.Quality.UNCERTAIN
  }
}
