package zio.aws.iotsitewise.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotsitewise.model.primitives.{Timestamp, ARN, Name, ID}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeGatewayResponse(
    gatewayId: ID,
    gatewayName: Name,
    gatewayArn: ARN,
    gatewayPlatform: Optional[zio.aws.iotsitewise.model.GatewayPlatform] =
      Optional.Absent,
    gatewayCapabilitySummaries: Iterable[
      zio.aws.iotsitewise.model.GatewayCapabilitySummary
    ],
    creationDate: Timestamp,
    lastUpdateDate: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.DescribeGatewayResponse = {
    import DescribeGatewayResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.DescribeGatewayResponse
      .builder()
      .gatewayId(ID.unwrap(gatewayId): java.lang.String)
      .gatewayName(Name.unwrap(gatewayName): java.lang.String)
      .gatewayArn(ARN.unwrap(gatewayArn): java.lang.String)
      .optionallyWith(gatewayPlatform.map(value => value.buildAwsValue()))(
        _.gatewayPlatform
      )
      .gatewayCapabilitySummaries(gatewayCapabilitySummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .creationDate(Timestamp.unwrap(creationDate): Instant)
      .lastUpdateDate(Timestamp.unwrap(lastUpdateDate): Instant)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.DescribeGatewayResponse.ReadOnly =
    zio.aws.iotsitewise.model.DescribeGatewayResponse.wrap(buildAwsValue())
}
object DescribeGatewayResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.DescribeGatewayResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.DescribeGatewayResponse =
      zio.aws.iotsitewise.model.DescribeGatewayResponse(
        gatewayId,
        gatewayName,
        gatewayArn,
        gatewayPlatform.map(value => value.asEditable),
        gatewayCapabilitySummaries.map { item =>
          item.asEditable
        },
        creationDate,
        lastUpdateDate
      )
    def gatewayId: ID
    def gatewayName: Name
    def gatewayArn: ARN
    def gatewayPlatform
        : Optional[zio.aws.iotsitewise.model.GatewayPlatform.ReadOnly]
    def gatewayCapabilitySummaries
        : List[zio.aws.iotsitewise.model.GatewayCapabilitySummary.ReadOnly]
    def creationDate: Timestamp
    def lastUpdateDate: Timestamp
    def getGatewayId: ZIO[Any, Nothing, ID] = ZIO.succeed(gatewayId)
    def getGatewayName: ZIO[Any, Nothing, Name] = ZIO.succeed(gatewayName)
    def getGatewayArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(gatewayArn)
    def getGatewayPlatform: ZIO[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.GatewayPlatform.ReadOnly
    ] = AwsError.unwrapOptionField("gatewayPlatform", gatewayPlatform)
    def getGatewayCapabilitySummaries: ZIO[Any, Nothing, List[
      zio.aws.iotsitewise.model.GatewayCapabilitySummary.ReadOnly
    ]] = ZIO.succeed(gatewayCapabilitySummaries)
    def getCreationDate: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationDate)
    def getLastUpdateDate: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastUpdateDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeGatewayResponse
  ) extends zio.aws.iotsitewise.model.DescribeGatewayResponse.ReadOnly {
    override val gatewayId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.gatewayId())
    override val gatewayName: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.gatewayName())
    override val gatewayArn: ARN =
      zio.aws.iotsitewise.model.primitives.ARN(impl.gatewayArn())
    override val gatewayPlatform
        : Optional[zio.aws.iotsitewise.model.GatewayPlatform.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gatewayPlatform())
        .map(value => zio.aws.iotsitewise.model.GatewayPlatform.wrap(value))
    override val gatewayCapabilitySummaries
        : List[zio.aws.iotsitewise.model.GatewayCapabilitySummary.ReadOnly] =
      impl
        .gatewayCapabilitySummaries()
        .asScala
        .map { item =>
          zio.aws.iotsitewise.model.GatewayCapabilitySummary.wrap(item)
        }
        .toList
    override val creationDate: Timestamp =
      zio.aws.iotsitewise.model.primitives.Timestamp(impl.creationDate())
    override val lastUpdateDate: Timestamp =
      zio.aws.iotsitewise.model.primitives.Timestamp(impl.lastUpdateDate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeGatewayResponse
  ): zio.aws.iotsitewise.model.DescribeGatewayResponse.ReadOnly = new Wrapper(
    impl
  )
}
