package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.ID
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeBulkImportJobRequest(jobId: ID) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.DescribeBulkImportJobRequest = {
    import DescribeBulkImportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.DescribeBulkImportJobRequest
      .builder()
      .jobId(ID.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.DescribeBulkImportJobRequest.ReadOnly =
    zio.aws.iotsitewise.model.DescribeBulkImportJobRequest.wrap(buildAwsValue())
}
object DescribeBulkImportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.DescribeBulkImportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.DescribeBulkImportJobRequest =
      zio.aws.iotsitewise.model.DescribeBulkImportJobRequest(jobId)
    def jobId: ID
    def getJobId: ZIO[Any, Nothing, ID] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeBulkImportJobRequest
  ) extends zio.aws.iotsitewise.model.DescribeBulkImportJobRequest.ReadOnly {
    override val jobId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeBulkImportJobRequest
  ): zio.aws.iotsitewise.model.DescribeBulkImportJobRequest.ReadOnly =
    new Wrapper(impl)
}
