package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Csv(
    columnNames: Optional[Iterable[zio.aws.iotsitewise.model.ColumnName]] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.iotsitewise.model.Csv = {
    import Csv.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.Csv
      .builder()
      .optionallyWith(
        columnNames.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.columnNamesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.Csv.ReadOnly =
    zio.aws.iotsitewise.model.Csv.wrap(buildAwsValue())
}
object Csv {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iotsitewise.model.Csv] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.Csv =
      zio.aws.iotsitewise.model.Csv(columnNames.map(value => value))
    def columnNames: Optional[List[zio.aws.iotsitewise.model.ColumnName]]
    def getColumnNames
        : ZIO[Any, AwsError, List[zio.aws.iotsitewise.model.ColumnName]] =
      AwsError.unwrapOptionField("columnNames", columnNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.Csv
  ) extends zio.aws.iotsitewise.model.Csv.ReadOnly {
    override val columnNames
        : Optional[List[zio.aws.iotsitewise.model.ColumnName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.columnNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotsitewise.model.ColumnName.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.Csv
  ): zio.aws.iotsitewise.model.Csv.ReadOnly = new Wrapper(impl)
}
