package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{Name, ID}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateBulkImportJobResponse(
    jobId: ID,
    jobName: Name,
    jobStatus: zio.aws.iotsitewise.model.JobStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.CreateBulkImportJobResponse = {
    import CreateBulkImportJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.CreateBulkImportJobResponse
      .builder()
      .jobId(ID.unwrap(jobId): java.lang.String)
      .jobName(Name.unwrap(jobName): java.lang.String)
      .jobStatus(jobStatus.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.CreateBulkImportJobResponse.ReadOnly =
    zio.aws.iotsitewise.model.CreateBulkImportJobResponse.wrap(buildAwsValue())
}
object CreateBulkImportJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.CreateBulkImportJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.CreateBulkImportJobResponse =
      zio.aws.iotsitewise.model
        .CreateBulkImportJobResponse(jobId, jobName, jobStatus)
    def jobId: ID
    def jobName: Name
    def jobStatus: zio.aws.iotsitewise.model.JobStatus
    def getJobId: ZIO[Any, Nothing, ID] = ZIO.succeed(jobId)
    def getJobName: ZIO[Any, Nothing, Name] = ZIO.succeed(jobName)
    def getJobStatus: ZIO[Any, Nothing, zio.aws.iotsitewise.model.JobStatus] =
      ZIO.succeed(jobStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.CreateBulkImportJobResponse
  ) extends zio.aws.iotsitewise.model.CreateBulkImportJobResponse.ReadOnly {
    override val jobId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.jobId())
    override val jobName: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.jobName())
    override val jobStatus: zio.aws.iotsitewise.model.JobStatus =
      zio.aws.iotsitewise.model.JobStatus.wrap(impl.jobStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.CreateBulkImportJobResponse
  ): zio.aws.iotsitewise.model.CreateBulkImportJobResponse.ReadOnly =
    new Wrapper(impl)
}
