package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{ClientToken, ID}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchDisassociateProjectAssetsRequest(
    projectId: ID,
    assetIds: Iterable[ID],
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.BatchDisassociateProjectAssetsRequest = {
    import BatchDisassociateProjectAssetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.BatchDisassociateProjectAssetsRequest
      .builder()
      .projectId(ID.unwrap(projectId): java.lang.String)
      .assetIds(assetIds.map { item =>
        ID.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.BatchDisassociateProjectAssetsRequest.ReadOnly =
    zio.aws.iotsitewise.model.BatchDisassociateProjectAssetsRequest
      .wrap(buildAwsValue())
}
object BatchDisassociateProjectAssetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.BatchDisassociateProjectAssetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotsitewise.model.BatchDisassociateProjectAssetsRequest =
      zio.aws.iotsitewise.model.BatchDisassociateProjectAssetsRequest(
        projectId,
        assetIds,
        clientToken.map(value => value)
      )
    def projectId: ID
    def assetIds: List[ID]
    def clientToken: Optional[ClientToken]
    def getProjectId: ZIO[Any, Nothing, ID] = ZIO.succeed(projectId)
    def getAssetIds: ZIO[Any, Nothing, List[ID]] = ZIO.succeed(assetIds)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchDisassociateProjectAssetsRequest
  ) extends zio.aws.iotsitewise.model.BatchDisassociateProjectAssetsRequest.ReadOnly {
    override val projectId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.projectId())
    override val assetIds: List[ID] = impl
      .assetIds()
      .asScala
      .map { item =>
        zio.aws.iotsitewise.model.primitives.ID(item)
      }
      .toList
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.iotsitewise.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchDisassociateProjectAssetsRequest
  ): zio.aws.iotsitewise.model.BatchDisassociateProjectAssetsRequest.ReadOnly =
    new Wrapper(impl)
}
