package zio.aws.iotsitewise.model
import scala.jdk.CollectionConverters._
sealed trait TraversalType {
  def unwrap: software.amazon.awssdk.services.iotsitewise.model.TraversalType
}
object TraversalType {
  def wrap(
      value: software.amazon.awssdk.services.iotsitewise.model.TraversalType
  ): zio.aws.iotsitewise.model.TraversalType = value match {
    case software.amazon.awssdk.services.iotsitewise.model.TraversalType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotsitewise.model.TraversalType.PATH_TO_ROOT =>
      val r = PATH_TO_ROOT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotsitewise.model.TraversalType {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.TraversalType =
      software.amazon.awssdk.services.iotsitewise.model.TraversalType.UNKNOWN_TO_SDK_VERSION
  }
  case object PATH_TO_ROOT extends zio.aws.iotsitewise.model.TraversalType {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.TraversalType =
      software.amazon.awssdk.services.iotsitewise.model.TraversalType.PATH_TO_ROOT
  }
}
