package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TransformProcessingConfig(
    computeLocation: zio.aws.iotsitewise.model.ComputeLocation,
    forwardingConfig: Optional[zio.aws.iotsitewise.model.ForwardingConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.TransformProcessingConfig = {
    import TransformProcessingConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.TransformProcessingConfig
      .builder()
      .computeLocation(computeLocation.unwrap)
      .optionallyWith(forwardingConfig.map(value => value.buildAwsValue()))(
        _.forwardingConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.TransformProcessingConfig.ReadOnly =
    zio.aws.iotsitewise.model.TransformProcessingConfig.wrap(buildAwsValue())
}
object TransformProcessingConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.TransformProcessingConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.TransformProcessingConfig =
      zio.aws.iotsitewise.model.TransformProcessingConfig(
        computeLocation,
        forwardingConfig.map(value => value.asEditable)
      )
    def computeLocation: zio.aws.iotsitewise.model.ComputeLocation
    def forwardingConfig
        : Optional[zio.aws.iotsitewise.model.ForwardingConfig.ReadOnly]
    def getComputeLocation
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.ComputeLocation] =
      ZIO.succeed(computeLocation)
    def getForwardingConfig: ZIO[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.ForwardingConfig.ReadOnly
    ] = AwsError.unwrapOptionField("forwardingConfig", forwardingConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.TransformProcessingConfig
  ) extends zio.aws.iotsitewise.model.TransformProcessingConfig.ReadOnly {
    override val computeLocation: zio.aws.iotsitewise.model.ComputeLocation =
      zio.aws.iotsitewise.model.ComputeLocation.wrap(impl.computeLocation())
    override val forwardingConfig
        : Optional[zio.aws.iotsitewise.model.ForwardingConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.forwardingConfig())
        .map(value => zio.aws.iotsitewise.model.ForwardingConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.TransformProcessingConfig
  ): zio.aws.iotsitewise.model.TransformProcessingConfig.ReadOnly = new Wrapper(
    impl
  )
}
