package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetAssetPropertyAggregatesResponse(
    aggregatedValues: Iterable[zio.aws.iotsitewise.model.AggregatedValue],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyAggregatesResponse = {
    import GetAssetPropertyAggregatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyAggregatesResponse
      .builder()
      .aggregatedValues(aggregatedValues.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.GetAssetPropertyAggregatesResponse.ReadOnly =
    zio.aws.iotsitewise.model.GetAssetPropertyAggregatesResponse
      .wrap(buildAwsValue())
}
object GetAssetPropertyAggregatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyAggregatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotsitewise.model.GetAssetPropertyAggregatesResponse =
      zio.aws.iotsitewise.model.GetAssetPropertyAggregatesResponse(
        aggregatedValues.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def aggregatedValues
        : List[zio.aws.iotsitewise.model.AggregatedValue.ReadOnly]
    def nextToken: Optional[NextToken]
    def getAggregatedValues: ZIO[Any, Nothing, List[
      zio.aws.iotsitewise.model.AggregatedValue.ReadOnly
    ]] = ZIO.succeed(aggregatedValues)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyAggregatesResponse
  ) extends zio.aws.iotsitewise.model.GetAssetPropertyAggregatesResponse.ReadOnly {
    override val aggregatedValues
        : List[zio.aws.iotsitewise.model.AggregatedValue.ReadOnly] = impl
      .aggregatedValues()
      .asScala
      .map { item =>
        zio.aws.iotsitewise.model.AggregatedValue.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotsitewise.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyAggregatesResponse
  ): zio.aws.iotsitewise.model.GetAssetPropertyAggregatesResponse.ReadOnly =
    new Wrapper(impl)
}
