package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.CapabilityNamespace
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GatewayCapabilitySummary(
    capabilityNamespace: CapabilityNamespace,
    capabilitySyncStatus: zio.aws.iotsitewise.model.CapabilitySyncStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.GatewayCapabilitySummary = {
    import GatewayCapabilitySummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.GatewayCapabilitySummary
      .builder()
      .capabilityNamespace(
        CapabilityNamespace.unwrap(capabilityNamespace): java.lang.String
      )
      .capabilitySyncStatus(capabilitySyncStatus.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.GatewayCapabilitySummary.ReadOnly =
    zio.aws.iotsitewise.model.GatewayCapabilitySummary.wrap(buildAwsValue())
}
object GatewayCapabilitySummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.GatewayCapabilitySummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.GatewayCapabilitySummary =
      zio.aws.iotsitewise.model
        .GatewayCapabilitySummary(capabilityNamespace, capabilitySyncStatus)
    def capabilityNamespace: CapabilityNamespace
    def capabilitySyncStatus: zio.aws.iotsitewise.model.CapabilitySyncStatus
    def getCapabilityNamespace: ZIO[Any, Nothing, CapabilityNamespace] =
      ZIO.succeed(capabilityNamespace)
    def getCapabilitySyncStatus
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.CapabilitySyncStatus] =
      ZIO.succeed(capabilitySyncStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.GatewayCapabilitySummary
  ) extends zio.aws.iotsitewise.model.GatewayCapabilitySummary.ReadOnly {
    override val capabilityNamespace: CapabilityNamespace =
      zio.aws.iotsitewise.model.primitives
        .CapabilityNamespace(impl.capabilityNamespace())
    override val capabilitySyncStatus
        : zio.aws.iotsitewise.model.CapabilitySyncStatus =
      zio.aws.iotsitewise.model.CapabilitySyncStatus
        .wrap(impl.capabilitySyncStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.GatewayCapabilitySummary
  ): zio.aws.iotsitewise.model.GatewayCapabilitySummary.ReadOnly = new Wrapper(
    impl
  )
}
