package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FileFormat(
    csv: Optional[zio.aws.iotsitewise.model.Csv] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.FileFormat = {
    import FileFormat.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.FileFormat
      .builder()
      .optionallyWith(csv.map(value => value.buildAwsValue()))(_.csv)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.FileFormat.ReadOnly =
    zio.aws.iotsitewise.model.FileFormat.wrap(buildAwsValue())
}
object FileFormat {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.FileFormat
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.FileFormat =
      zio.aws.iotsitewise.model.FileFormat(csv.map(value => value.asEditable))
    def csv: Optional[zio.aws.iotsitewise.model.Csv.ReadOnly]
    def getCsv: ZIO[Any, AwsError, zio.aws.iotsitewise.model.Csv.ReadOnly] =
      AwsError.unwrapOptionField("csv", csv)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.FileFormat
  ) extends zio.aws.iotsitewise.model.FileFormat.ReadOnly {
    override val csv: Optional[zio.aws.iotsitewise.model.Csv.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.csv())
        .map(value => zio.aws.iotsitewise.model.Csv.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.FileFormat
  ): zio.aws.iotsitewise.model.FileFormat.ReadOnly = new Wrapper(impl)
}
