package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{ClientToken, ID, PropertyAlias}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DisassociateTimeSeriesFromAssetPropertyRequest(
    alias: PropertyAlias,
    assetId: ID,
    propertyId: ID,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.DisassociateTimeSeriesFromAssetPropertyRequest = {
    import DisassociateTimeSeriesFromAssetPropertyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.DisassociateTimeSeriesFromAssetPropertyRequest
      .builder()
      .alias(PropertyAlias.unwrap(alias): java.lang.String)
      .assetId(ID.unwrap(assetId): java.lang.String)
      .propertyId(ID.unwrap(propertyId): java.lang.String)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.DisassociateTimeSeriesFromAssetPropertyRequest.ReadOnly =
    zio.aws.iotsitewise.model.DisassociateTimeSeriesFromAssetPropertyRequest
      .wrap(buildAwsValue())
}
object DisassociateTimeSeriesFromAssetPropertyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.DisassociateTimeSeriesFromAssetPropertyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotsitewise.model.DisassociateTimeSeriesFromAssetPropertyRequest =
      zio.aws.iotsitewise.model.DisassociateTimeSeriesFromAssetPropertyRequest(
        alias,
        assetId,
        propertyId,
        clientToken.map(value => value)
      )
    def alias: PropertyAlias
    def assetId: ID
    def propertyId: ID
    def clientToken: Optional[ClientToken]
    def getAlias: ZIO[Any, Nothing, PropertyAlias] = ZIO.succeed(alias)
    def getAssetId: ZIO[Any, Nothing, ID] = ZIO.succeed(assetId)
    def getPropertyId: ZIO[Any, Nothing, ID] = ZIO.succeed(propertyId)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.DisassociateTimeSeriesFromAssetPropertyRequest
  ) extends zio.aws.iotsitewise.model.DisassociateTimeSeriesFromAssetPropertyRequest.ReadOnly {
    override val alias: PropertyAlias =
      zio.aws.iotsitewise.model.primitives.PropertyAlias(impl.alias())
    override val assetId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.assetId())
    override val propertyId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.propertyId())
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.iotsitewise.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.DisassociateTimeSeriesFromAssetPropertyRequest
  ): zio.aws.iotsitewise.model.DisassociateTimeSeriesFromAssetPropertyRequest.ReadOnly =
    new Wrapper(impl)
}
