package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{
  TagValue,
  Description,
  ClientToken,
  Name,
  TagKey
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateAssetModelRequest(
    assetModelName: Name,
    assetModelDescription: Optional[Description] = Optional.Absent,
    assetModelProperties: Optional[
      Iterable[zio.aws.iotsitewise.model.AssetModelPropertyDefinition]
    ] = Optional.Absent,
    assetModelHierarchies: Optional[
      Iterable[zio.aws.iotsitewise.model.AssetModelHierarchyDefinition]
    ] = Optional.Absent,
    assetModelCompositeModels: Optional[
      Iterable[zio.aws.iotsitewise.model.AssetModelCompositeModelDefinition]
    ] = Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.CreateAssetModelRequest = {
    import CreateAssetModelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.CreateAssetModelRequest
      .builder()
      .assetModelName(Name.unwrap(assetModelName): java.lang.String)
      .optionallyWith(
        assetModelDescription.map(value =>
          Description.unwrap(value): java.lang.String
        )
      )(_.assetModelDescription)
      .optionallyWith(
        assetModelProperties.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.assetModelProperties)
      .optionallyWith(
        assetModelHierarchies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.assetModelHierarchies)
      .optionallyWith(
        assetModelCompositeModels.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.assetModelCompositeModels)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.CreateAssetModelRequest.ReadOnly =
    zio.aws.iotsitewise.model.CreateAssetModelRequest.wrap(buildAwsValue())
}
object CreateAssetModelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.CreateAssetModelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.CreateAssetModelRequest =
      zio.aws.iotsitewise.model.CreateAssetModelRequest(
        assetModelName,
        assetModelDescription.map(value => value),
        assetModelProperties.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        assetModelHierarchies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        assetModelCompositeModels.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientToken.map(value => value),
        tags.map(value => value)
      )
    def assetModelName: Name
    def assetModelDescription: Optional[Description]
    def assetModelProperties: Optional[
      List[zio.aws.iotsitewise.model.AssetModelPropertyDefinition.ReadOnly]
    ]
    def assetModelHierarchies: Optional[
      List[zio.aws.iotsitewise.model.AssetModelHierarchyDefinition.ReadOnly]
    ]
    def assetModelCompositeModels: Optional[List[
      zio.aws.iotsitewise.model.AssetModelCompositeModelDefinition.ReadOnly
    ]]
    def clientToken: Optional[ClientToken]
    def tags: Optional[Map[TagKey, TagValue]]
    def getAssetModelName: ZIO[Any, Nothing, Name] = ZIO.succeed(assetModelName)
    def getAssetModelDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("assetModelDescription", assetModelDescription)
    def getAssetModelProperties: ZIO[Any, AwsError, List[
      zio.aws.iotsitewise.model.AssetModelPropertyDefinition.ReadOnly
    ]] =
      AwsError.unwrapOptionField("assetModelProperties", assetModelProperties)
    def getAssetModelHierarchies: ZIO[Any, AwsError, List[
      zio.aws.iotsitewise.model.AssetModelHierarchyDefinition.ReadOnly
    ]] =
      AwsError.unwrapOptionField("assetModelHierarchies", assetModelHierarchies)
    def getAssetModelCompositeModels: ZIO[Any, AwsError, List[
      zio.aws.iotsitewise.model.AssetModelCompositeModelDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "assetModelCompositeModels",
      assetModelCompositeModels
    )
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.CreateAssetModelRequest
  ) extends zio.aws.iotsitewise.model.CreateAssetModelRequest.ReadOnly {
    override val assetModelName: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.assetModelName())
    override val assetModelDescription: Optional[Description] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assetModelDescription())
        .map(value => zio.aws.iotsitewise.model.primitives.Description(value))
    override val assetModelProperties: Optional[
      List[zio.aws.iotsitewise.model.AssetModelPropertyDefinition.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.assetModelProperties())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotsitewise.model.AssetModelPropertyDefinition.wrap(item)
        }.toList
      )
    override val assetModelHierarchies: Optional[
      List[zio.aws.iotsitewise.model.AssetModelHierarchyDefinition.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.assetModelHierarchies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotsitewise.model.AssetModelHierarchyDefinition.wrap(item)
        }.toList
      )
    override val assetModelCompositeModels: Optional[List[
      zio.aws.iotsitewise.model.AssetModelCompositeModelDefinition.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.assetModelCompositeModels())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotsitewise.model.AssetModelCompositeModelDefinition
            .wrap(item)
        }.toList
      )
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.iotsitewise.model.primitives.ClientToken(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iotsitewise.model.primitives.TagKey(
              key
            ) -> zio.aws.iotsitewise.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.CreateAssetModelRequest
  ): zio.aws.iotsitewise.model.CreateAssetModelRequest.ReadOnly = new Wrapper(
    impl
  )
}
