package zio.aws.iotsitewise.model
import scala.jdk.CollectionConverters._
sealed trait TimeOrdering {
  def unwrap: software.amazon.awssdk.services.iotsitewise.model.TimeOrdering
}
object TimeOrdering {
  def wrap(
      value: software.amazon.awssdk.services.iotsitewise.model.TimeOrdering
  ): zio.aws.iotsitewise.model.TimeOrdering = value match {
    case software.amazon.awssdk.services.iotsitewise.model.TimeOrdering.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotsitewise.model.TimeOrdering.ASCENDING =>
      val r = ASCENDING
      r
    case software.amazon.awssdk.services.iotsitewise.model.TimeOrdering.DESCENDING =>
      val r = DESCENDING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotsitewise.model.TimeOrdering {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.TimeOrdering =
      software.amazon.awssdk.services.iotsitewise.model.TimeOrdering.UNKNOWN_TO_SDK_VERSION
  }
  case object ASCENDING extends zio.aws.iotsitewise.model.TimeOrdering {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.TimeOrdering =
      software.amazon.awssdk.services.iotsitewise.model.TimeOrdering.ASCENDING
  }
  case object DESCENDING extends zio.aws.iotsitewise.model.TimeOrdering {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.TimeOrdering =
      software.amazon.awssdk.services.iotsitewise.model.TimeOrdering.DESCENDING
  }
}
