package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.KmsKeyId
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutDefaultEncryptionConfigurationRequest(
    encryptionType: zio.aws.iotsitewise.model.EncryptionType,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.PutDefaultEncryptionConfigurationRequest = {
    import PutDefaultEncryptionConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.PutDefaultEncryptionConfigurationRequest
      .builder()
      .encryptionType(encryptionType.unwrap)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.PutDefaultEncryptionConfigurationRequest.ReadOnly =
    zio.aws.iotsitewise.model.PutDefaultEncryptionConfigurationRequest
      .wrap(buildAwsValue())
}
object PutDefaultEncryptionConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.PutDefaultEncryptionConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotsitewise.model.PutDefaultEncryptionConfigurationRequest =
      zio.aws.iotsitewise.model.PutDefaultEncryptionConfigurationRequest(
        encryptionType,
        kmsKeyId.map(value => value)
      )
    def encryptionType: zio.aws.iotsitewise.model.EncryptionType
    def kmsKeyId: Optional[KmsKeyId]
    def getEncryptionType
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.EncryptionType] =
      ZIO.succeed(encryptionType)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.PutDefaultEncryptionConfigurationRequest
  ) extends zio.aws.iotsitewise.model.PutDefaultEncryptionConfigurationRequest.ReadOnly {
    override val encryptionType: zio.aws.iotsitewise.model.EncryptionType =
      zio.aws.iotsitewise.model.EncryptionType.wrap(impl.encryptionType())
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.iotsitewise.model.primitives.KmsKeyId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.PutDefaultEncryptionConfigurationRequest
  ): zio.aws.iotsitewise.model.PutDefaultEncryptionConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
