package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.MonitorErrorMessage
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MonitorErrorDetails(
    code: Optional[zio.aws.iotsitewise.model.MonitorErrorCode] =
      Optional.Absent,
    message: Optional[MonitorErrorMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.MonitorErrorDetails = {
    import MonitorErrorDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.MonitorErrorDetails
      .builder()
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .optionallyWith(
        message.map(value =>
          MonitorErrorMessage.unwrap(value): java.lang.String
        )
      )(_.message)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.MonitorErrorDetails.ReadOnly =
    zio.aws.iotsitewise.model.MonitorErrorDetails.wrap(buildAwsValue())
}
object MonitorErrorDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.MonitorErrorDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.MonitorErrorDetails =
      zio.aws.iotsitewise.model.MonitorErrorDetails(
        code.map(value => value),
        message.map(value => value)
      )
    def code: Optional[zio.aws.iotsitewise.model.MonitorErrorCode]
    def message: Optional[MonitorErrorMessage]
    def getCode
        : ZIO[Any, AwsError, zio.aws.iotsitewise.model.MonitorErrorCode] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, MonitorErrorMessage] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.MonitorErrorDetails
  ) extends zio.aws.iotsitewise.model.MonitorErrorDetails.ReadOnly {
    override val code: Optional[zio.aws.iotsitewise.model.MonitorErrorCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.code())
        .map(value => zio.aws.iotsitewise.model.MonitorErrorCode.wrap(value))
    override val message: Optional[MonitorErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value =>
        zio.aws.iotsitewise.model.primitives.MonitorErrorMessage(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.MonitorErrorDetails
  ): zio.aws.iotsitewise.model.MonitorErrorDetails.ReadOnly = new Wrapper(impl)
}
