package zio.aws.iotsitewise.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotsitewise.model.primitives.{MaxResults, NextToken}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListBulkImportJobsRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    filter: Optional[zio.aws.iotsitewise.model.ListBulkImportJobsFilter] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.ListBulkImportJobsRequest = {
    import ListBulkImportJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.ListBulkImportJobsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(filter.map(value => value.unwrap))(_.filter)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.ListBulkImportJobsRequest.ReadOnly =
    zio.aws.iotsitewise.model.ListBulkImportJobsRequest.wrap(buildAwsValue())
}
object ListBulkImportJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.ListBulkImportJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.ListBulkImportJobsRequest =
      zio.aws.iotsitewise.model.ListBulkImportJobsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        filter.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def filter: Optional[zio.aws.iotsitewise.model.ListBulkImportJobsFilter]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.ListBulkImportJobsFilter
    ] = AwsError.unwrapOptionField("filter", filter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListBulkImportJobsRequest
  ) extends zio.aws.iotsitewise.model.ListBulkImportJobsRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotsitewise.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iotsitewise.model.primitives.MaxResults(value))
    override val filter
        : Optional[zio.aws.iotsitewise.model.ListBulkImportJobsFilter] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value =>
          zio.aws.iotsitewise.model.ListBulkImportJobsFilter.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListBulkImportJobsRequest
  ): zio.aws.iotsitewise.model.ListBulkImportJobsRequest.ReadOnly = new Wrapper(
    impl
  )
}
