package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAssetPropertiesResponse(
    assetPropertySummaries: Iterable[
      zio.aws.iotsitewise.model.AssetPropertySummary
    ],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.ListAssetPropertiesResponse = {
    import ListAssetPropertiesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.ListAssetPropertiesResponse
      .builder()
      .assetPropertySummaries(assetPropertySummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.ListAssetPropertiesResponse.ReadOnly =
    zio.aws.iotsitewise.model.ListAssetPropertiesResponse.wrap(buildAwsValue())
}
object ListAssetPropertiesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.ListAssetPropertiesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.ListAssetPropertiesResponse =
      zio.aws.iotsitewise.model.ListAssetPropertiesResponse(
        assetPropertySummaries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def assetPropertySummaries
        : List[zio.aws.iotsitewise.model.AssetPropertySummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def getAssetPropertySummaries: ZIO[Any, Nothing, List[
      zio.aws.iotsitewise.model.AssetPropertySummary.ReadOnly
    ]] = ZIO.succeed(assetPropertySummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListAssetPropertiesResponse
  ) extends zio.aws.iotsitewise.model.ListAssetPropertiesResponse.ReadOnly {
    override val assetPropertySummaries
        : List[zio.aws.iotsitewise.model.AssetPropertySummary.ReadOnly] = impl
      .assetPropertySummaries()
      .asScala
      .map { item =>
        zio.aws.iotsitewise.model.AssetPropertySummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotsitewise.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListAssetPropertiesResponse
  ): zio.aws.iotsitewise.model.ListAssetPropertiesResponse.ReadOnly =
    new Wrapper(impl)
}
