package zio.aws.iotsitewise.model
import scala.jdk.CollectionConverters._
sealed trait ImageFileType {
  def unwrap: software.amazon.awssdk.services.iotsitewise.model.ImageFileType
}
object ImageFileType {
  def wrap(
      value: software.amazon.awssdk.services.iotsitewise.model.ImageFileType
  ): zio.aws.iotsitewise.model.ImageFileType = value match {
    case software.amazon.awssdk.services.iotsitewise.model.ImageFileType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotsitewise.model.ImageFileType.PNG =>
      val r = PNG
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotsitewise.model.ImageFileType {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.ImageFileType =
      software.amazon.awssdk.services.iotsitewise.model.ImageFileType.UNKNOWN_TO_SDK_VERSION
  }
  case object PNG extends zio.aws.iotsitewise.model.ImageFileType {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.ImageFileType =
      software.amazon.awssdk.services.iotsitewise.model.ImageFileType.PNG
  }
}
