package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{AssetErrorMessage, ID}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AssetErrorDetails(
    assetId: ID,
    code: zio.aws.iotsitewise.model.AssetErrorCode,
    message: AssetErrorMessage
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.AssetErrorDetails = {
    import AssetErrorDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.AssetErrorDetails
      .builder()
      .assetId(ID.unwrap(assetId): java.lang.String)
      .code(code.unwrap)
      .message(AssetErrorMessage.unwrap(message): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.AssetErrorDetails.ReadOnly =
    zio.aws.iotsitewise.model.AssetErrorDetails.wrap(buildAwsValue())
}
object AssetErrorDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.AssetErrorDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.AssetErrorDetails =
      zio.aws.iotsitewise.model.AssetErrorDetails(assetId, code, message)
    def assetId: ID
    def code: zio.aws.iotsitewise.model.AssetErrorCode
    def message: AssetErrorMessage
    def getAssetId: ZIO[Any, Nothing, ID] = ZIO.succeed(assetId)
    def getCode: ZIO[Any, Nothing, zio.aws.iotsitewise.model.AssetErrorCode] =
      ZIO.succeed(code)
    def getMessage: ZIO[Any, Nothing, AssetErrorMessage] = ZIO.succeed(message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.AssetErrorDetails
  ) extends zio.aws.iotsitewise.model.AssetErrorDetails.ReadOnly {
    override val assetId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.assetId())
    override val code: zio.aws.iotsitewise.model.AssetErrorCode =
      zio.aws.iotsitewise.model.AssetErrorCode.wrap(impl.code())
    override val message: AssetErrorMessage =
      zio.aws.iotsitewise.model.primitives.AssetErrorMessage(impl.message())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.AssetErrorDetails
  ): zio.aws.iotsitewise.model.AssetErrorDetails.ReadOnly = new Wrapper(impl)
}
