package zio.aws.iotsitewise.model
import scala.jdk.CollectionConverters._
sealed trait ResourceType {
  def unwrap: software.amazon.awssdk.services.iotsitewise.model.ResourceType
}
object ResourceType {
  def wrap(
      value: software.amazon.awssdk.services.iotsitewise.model.ResourceType
  ): zio.aws.iotsitewise.model.ResourceType = value match {
    case software.amazon.awssdk.services.iotsitewise.model.ResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotsitewise.model.ResourceType.PORTAL =>
      val r = PORTAL
      r
    case software.amazon.awssdk.services.iotsitewise.model.ResourceType.PROJECT =>
      val r = PROJECT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotsitewise.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.ResourceType =
      software.amazon.awssdk.services.iotsitewise.model.ResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object PORTAL extends zio.aws.iotsitewise.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.ResourceType =
      software.amazon.awssdk.services.iotsitewise.model.ResourceType.PORTAL
  }
  case object PROJECT extends zio.aws.iotsitewise.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.ResourceType =
      software.amazon.awssdk.services.iotsitewise.model.ResourceType.PROJECT
  }
}
