package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{AssetPropertyAlias, ID, EntryId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutAssetPropertyValueEntry(
    entryId: EntryId,
    assetId: Optional[ID] = Optional.Absent,
    propertyId: Optional[ID] = Optional.Absent,
    propertyAlias: Optional[AssetPropertyAlias] = Optional.Absent,
    propertyValues: Iterable[zio.aws.iotsitewise.model.AssetPropertyValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.PutAssetPropertyValueEntry = {
    import PutAssetPropertyValueEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.PutAssetPropertyValueEntry
      .builder()
      .entryId(EntryId.unwrap(entryId): java.lang.String)
      .optionallyWith(assetId.map(value => ID.unwrap(value): java.lang.String))(
        _.assetId
      )
      .optionallyWith(
        propertyId.map(value => ID.unwrap(value): java.lang.String)
      )(_.propertyId)
      .optionallyWith(
        propertyAlias.map(value =>
          AssetPropertyAlias.unwrap(value): java.lang.String
        )
      )(_.propertyAlias)
      .propertyValues(propertyValues.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.PutAssetPropertyValueEntry.ReadOnly =
    zio.aws.iotsitewise.model.PutAssetPropertyValueEntry.wrap(buildAwsValue())
}
object PutAssetPropertyValueEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.PutAssetPropertyValueEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.PutAssetPropertyValueEntry =
      zio.aws.iotsitewise.model.PutAssetPropertyValueEntry(
        entryId,
        assetId.map(value => value),
        propertyId.map(value => value),
        propertyAlias.map(value => value),
        propertyValues.map { item =>
          item.asEditable
        }
      )
    def entryId: EntryId
    def assetId: Optional[ID]
    def propertyId: Optional[ID]
    def propertyAlias: Optional[AssetPropertyAlias]
    def propertyValues
        : List[zio.aws.iotsitewise.model.AssetPropertyValue.ReadOnly]
    def getEntryId: ZIO[Any, Nothing, EntryId] = ZIO.succeed(entryId)
    def getAssetId: ZIO[Any, AwsError, ID] =
      AwsError.unwrapOptionField("assetId", assetId)
    def getPropertyId: ZIO[Any, AwsError, ID] =
      AwsError.unwrapOptionField("propertyId", propertyId)
    def getPropertyAlias: ZIO[Any, AwsError, AssetPropertyAlias] =
      AwsError.unwrapOptionField("propertyAlias", propertyAlias)
    def getPropertyValues: ZIO[Any, Nothing, List[
      zio.aws.iotsitewise.model.AssetPropertyValue.ReadOnly
    ]] = ZIO.succeed(propertyValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.PutAssetPropertyValueEntry
  ) extends zio.aws.iotsitewise.model.PutAssetPropertyValueEntry.ReadOnly {
    override val entryId: EntryId =
      zio.aws.iotsitewise.model.primitives.EntryId(impl.entryId())
    override val assetId: Optional[ID] = zio.aws.core.internal
      .optionalFromNullable(impl.assetId())
      .map(value => zio.aws.iotsitewise.model.primitives.ID(value))
    override val propertyId: Optional[ID] = zio.aws.core.internal
      .optionalFromNullable(impl.propertyId())
      .map(value => zio.aws.iotsitewise.model.primitives.ID(value))
    override val propertyAlias: Optional[AssetPropertyAlias] =
      zio.aws.core.internal
        .optionalFromNullable(impl.propertyAlias())
        .map(value =>
          zio.aws.iotsitewise.model.primitives.AssetPropertyAlias(value)
        )
    override val propertyValues
        : List[zio.aws.iotsitewise.model.AssetPropertyValue.ReadOnly] = impl
      .propertyValues()
      .asScala
      .map { item =>
        zio.aws.iotsitewise.model.AssetPropertyValue.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.PutAssetPropertyValueEntry
  ): zio.aws.iotsitewise.model.PutAssetPropertyValueEntry.ReadOnly =
    new Wrapper(impl)
}
