package zio.aws.iotsitewise.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotsitewise.model.primitives.{MaxResults, NextToken, ID}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListAssetRelationshipsRequest(
    assetId: ID,
    traversalType: zio.aws.iotsitewise.model.TraversalType,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.ListAssetRelationshipsRequest = {
    import ListAssetRelationshipsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.ListAssetRelationshipsRequest
      .builder()
      .assetId(ID.unwrap(assetId): java.lang.String)
      .traversalType(traversalType.unwrap)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.ListAssetRelationshipsRequest.ReadOnly =
    zio.aws.iotsitewise.model.ListAssetRelationshipsRequest
      .wrap(buildAwsValue())
}
object ListAssetRelationshipsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.ListAssetRelationshipsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.ListAssetRelationshipsRequest =
      zio.aws.iotsitewise.model.ListAssetRelationshipsRequest(
        assetId,
        traversalType,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def assetId: ID
    def traversalType: zio.aws.iotsitewise.model.TraversalType
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getAssetId: ZIO[Any, Nothing, ID] = ZIO.succeed(assetId)
    def getTraversalType
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.TraversalType] =
      ZIO.succeed(traversalType)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListAssetRelationshipsRequest
  ) extends zio.aws.iotsitewise.model.ListAssetRelationshipsRequest.ReadOnly {
    override val assetId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.assetId())
    override val traversalType: zio.aws.iotsitewise.model.TraversalType =
      zio.aws.iotsitewise.model.TraversalType.wrap(impl.traversalType())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotsitewise.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iotsitewise.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListAssetRelationshipsRequest
  ): zio.aws.iotsitewise.model.ListAssetRelationshipsRequest.ReadOnly =
    new Wrapper(impl)
}
