package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAccessPoliciesResponse(
    accessPolicySummaries: Iterable[
      zio.aws.iotsitewise.model.AccessPolicySummary
    ],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.ListAccessPoliciesResponse = {
    import ListAccessPoliciesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.ListAccessPoliciesResponse
      .builder()
      .accessPolicySummaries(accessPolicySummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.ListAccessPoliciesResponse.ReadOnly =
    zio.aws.iotsitewise.model.ListAccessPoliciesResponse.wrap(buildAwsValue())
}
object ListAccessPoliciesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.ListAccessPoliciesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.ListAccessPoliciesResponse =
      zio.aws.iotsitewise.model.ListAccessPoliciesResponse(
        accessPolicySummaries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def accessPolicySummaries
        : List[zio.aws.iotsitewise.model.AccessPolicySummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def getAccessPolicySummaries: ZIO[Any, Nothing, List[
      zio.aws.iotsitewise.model.AccessPolicySummary.ReadOnly
    ]] = ZIO.succeed(accessPolicySummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListAccessPoliciesResponse
  ) extends zio.aws.iotsitewise.model.ListAccessPoliciesResponse.ReadOnly {
    override val accessPolicySummaries
        : List[zio.aws.iotsitewise.model.AccessPolicySummary.ReadOnly] = impl
      .accessPolicySummaries()
      .asScala
      .map { item =>
        zio.aws.iotsitewise.model.AccessPolicySummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotsitewise.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListAccessPoliciesResponse
  ): zio.aws.iotsitewise.model.ListAccessPoliciesResponse.ReadOnly =
    new Wrapper(impl)
}
