package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.Bucket
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class File(
    bucket: Bucket,
    key: String,
    versionId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.File = {
    import File.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.File
      .builder()
      .bucket(Bucket.unwrap(bucket): java.lang.String)
      .key(key: java.lang.String)
      .optionallyWith(versionId.map(value => value: java.lang.String))(
        _.versionId
      )
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.File.ReadOnly =
    zio.aws.iotsitewise.model.File.wrap(buildAwsValue())
}
object File {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iotsitewise.model.File] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.File =
      zio.aws.iotsitewise.model.File(bucket, key, versionId.map(value => value))
    def bucket: Bucket
    def key: String
    def versionId: Optional[String]
    def getBucket: ZIO[Any, Nothing, Bucket] = ZIO.succeed(bucket)
    def getKey: ZIO[Any, Nothing, String] = ZIO.succeed(key)
    def getVersionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("versionId", versionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.File
  ) extends zio.aws.iotsitewise.model.File.ReadOnly {
    override val bucket: Bucket =
      zio.aws.iotsitewise.model.primitives.Bucket(impl.bucket())
    override val key: String = impl.key(): String
    override val versionId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.versionId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.File
  ): zio.aws.iotsitewise.model.File.ReadOnly = new Wrapper(impl)
}
