package zio.aws.iotsitewise.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotsitewise.model.primitives.{
  Timestamp,
  DashboardDefinition,
  Description,
  Name,
  ARN,
  ID
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeDashboardResponse(
    dashboardId: ID,
    dashboardArn: ARN,
    dashboardName: Name,
    projectId: ID,
    dashboardDescription: Optional[Description] = Optional.Absent,
    dashboardDefinition: DashboardDefinition,
    dashboardCreationDate: Timestamp,
    dashboardLastUpdateDate: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.DescribeDashboardResponse = {
    import DescribeDashboardResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.DescribeDashboardResponse
      .builder()
      .dashboardId(ID.unwrap(dashboardId): java.lang.String)
      .dashboardArn(ARN.unwrap(dashboardArn): java.lang.String)
      .dashboardName(Name.unwrap(dashboardName): java.lang.String)
      .projectId(ID.unwrap(projectId): java.lang.String)
      .optionallyWith(
        dashboardDescription.map(value =>
          Description.unwrap(value): java.lang.String
        )
      )(_.dashboardDescription)
      .dashboardDefinition(
        DashboardDefinition.unwrap(dashboardDefinition): java.lang.String
      )
      .dashboardCreationDate(Timestamp.unwrap(dashboardCreationDate): Instant)
      .dashboardLastUpdateDate(
        Timestamp.unwrap(dashboardLastUpdateDate): Instant
      )
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.DescribeDashboardResponse.ReadOnly =
    zio.aws.iotsitewise.model.DescribeDashboardResponse.wrap(buildAwsValue())
}
object DescribeDashboardResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.DescribeDashboardResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.DescribeDashboardResponse =
      zio.aws.iotsitewise.model.DescribeDashboardResponse(
        dashboardId,
        dashboardArn,
        dashboardName,
        projectId,
        dashboardDescription.map(value => value),
        dashboardDefinition,
        dashboardCreationDate,
        dashboardLastUpdateDate
      )
    def dashboardId: ID
    def dashboardArn: ARN
    def dashboardName: Name
    def projectId: ID
    def dashboardDescription: Optional[Description]
    def dashboardDefinition: DashboardDefinition
    def dashboardCreationDate: Timestamp
    def dashboardLastUpdateDate: Timestamp
    def getDashboardId: ZIO[Any, Nothing, ID] = ZIO.succeed(dashboardId)
    def getDashboardArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(dashboardArn)
    def getDashboardName: ZIO[Any, Nothing, Name] = ZIO.succeed(dashboardName)
    def getProjectId: ZIO[Any, Nothing, ID] = ZIO.succeed(projectId)
    def getDashboardDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("dashboardDescription", dashboardDescription)
    def getDashboardDefinition: ZIO[Any, Nothing, DashboardDefinition] =
      ZIO.succeed(dashboardDefinition)
    def getDashboardCreationDate: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(dashboardCreationDate)
    def getDashboardLastUpdateDate: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(dashboardLastUpdateDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeDashboardResponse
  ) extends zio.aws.iotsitewise.model.DescribeDashboardResponse.ReadOnly {
    override val dashboardId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.dashboardId())
    override val dashboardArn: ARN =
      zio.aws.iotsitewise.model.primitives.ARN(impl.dashboardArn())
    override val dashboardName: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.dashboardName())
    override val projectId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.projectId())
    override val dashboardDescription: Optional[Description] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dashboardDescription())
        .map(value => zio.aws.iotsitewise.model.primitives.Description(value))
    override val dashboardDefinition: DashboardDefinition =
      zio.aws.iotsitewise.model.primitives
        .DashboardDefinition(impl.dashboardDefinition())
    override val dashboardCreationDate: Timestamp =
      zio.aws.iotsitewise.model.primitives
        .Timestamp(impl.dashboardCreationDate())
    override val dashboardLastUpdateDate: Timestamp =
      zio.aws.iotsitewise.model.primitives
        .Timestamp(impl.dashboardLastUpdateDate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeDashboardResponse
  ): zio.aws.iotsitewise.model.DescribeDashboardResponse.ReadOnly = new Wrapper(
    impl
  )
}
