package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{ExcludeProperties, ID}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeAssetRequest(
    assetId: ID,
    excludeProperties: Optional[ExcludeProperties] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.DescribeAssetRequest = {
    import DescribeAssetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.DescribeAssetRequest
      .builder()
      .assetId(ID.unwrap(assetId): java.lang.String)
      .optionallyWith(
        excludeProperties.map(value =>
          ExcludeProperties.unwrap(value): java.lang.Boolean
        )
      )(_.excludeProperties)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.DescribeAssetRequest.ReadOnly =
    zio.aws.iotsitewise.model.DescribeAssetRequest.wrap(buildAwsValue())
}
object DescribeAssetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.DescribeAssetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.DescribeAssetRequest =
      zio.aws.iotsitewise.model
        .DescribeAssetRequest(assetId, excludeProperties.map(value => value))
    def assetId: ID
    def excludeProperties: Optional[ExcludeProperties]
    def getAssetId: ZIO[Any, Nothing, ID] = ZIO.succeed(assetId)
    def getExcludeProperties: ZIO[Any, AwsError, ExcludeProperties] =
      AwsError.unwrapOptionField("excludeProperties", excludeProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeAssetRequest
  ) extends zio.aws.iotsitewise.model.DescribeAssetRequest.ReadOnly {
    override val assetId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.assetId())
    override val excludeProperties: Optional[ExcludeProperties] =
      zio.aws.core.internal
        .optionalFromNullable(impl.excludeProperties())
        .map(value =>
          zio.aws.iotsitewise.model.primitives.ExcludeProperties(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeAssetRequest
  ): zio.aws.iotsitewise.model.DescribeAssetRequest.ReadOnly = new Wrapper(impl)
}
