package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.ID
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteGatewayRequest(gatewayId: ID) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.DeleteGatewayRequest = {
    import DeleteGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.DeleteGatewayRequest
      .builder()
      .gatewayId(ID.unwrap(gatewayId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.DeleteGatewayRequest.ReadOnly =
    zio.aws.iotsitewise.model.DeleteGatewayRequest.wrap(buildAwsValue())
}
object DeleteGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.DeleteGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.DeleteGatewayRequest =
      zio.aws.iotsitewise.model.DeleteGatewayRequest(gatewayId)
    def gatewayId: ID
    def getGatewayId: ZIO[Any, Nothing, ID] = ZIO.succeed(gatewayId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.DeleteGatewayRequest
  ) extends zio.aws.iotsitewise.model.DeleteGatewayRequest.ReadOnly {
    override val gatewayId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.gatewayId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.DeleteGatewayRequest
  ): zio.aws.iotsitewise.model.DeleteGatewayRequest.ReadOnly = new Wrapper(impl)
}
