package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{EntryId, ErrorMessage}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchGetAssetPropertyValueErrorEntry(
    errorCode: zio.aws.iotsitewise.model.BatchGetAssetPropertyValueErrorCode,
    errorMessage: ErrorMessage,
    entryId: EntryId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueErrorEntry = {
    import BatchGetAssetPropertyValueErrorEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueErrorEntry
      .builder()
      .errorCode(errorCode.unwrap)
      .errorMessage(ErrorMessage.unwrap(errorMessage): java.lang.String)
      .entryId(EntryId.unwrap(entryId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.BatchGetAssetPropertyValueErrorEntry.ReadOnly =
    zio.aws.iotsitewise.model.BatchGetAssetPropertyValueErrorEntry
      .wrap(buildAwsValue())
}
object BatchGetAssetPropertyValueErrorEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueErrorEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotsitewise.model.BatchGetAssetPropertyValueErrorEntry =
      zio.aws.iotsitewise.model
        .BatchGetAssetPropertyValueErrorEntry(errorCode, errorMessage, entryId)
    def errorCode: zio.aws.iotsitewise.model.BatchGetAssetPropertyValueErrorCode
    def errorMessage: ErrorMessage
    def entryId: EntryId
    def getErrorCode: ZIO[
      Any,
      Nothing,
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueErrorCode
    ] = ZIO.succeed(errorCode)
    def getErrorMessage: ZIO[Any, Nothing, ErrorMessage] =
      ZIO.succeed(errorMessage)
    def getEntryId: ZIO[Any, Nothing, EntryId] = ZIO.succeed(entryId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueErrorEntry
  ) extends zio.aws.iotsitewise.model.BatchGetAssetPropertyValueErrorEntry.ReadOnly {
    override val errorCode
        : zio.aws.iotsitewise.model.BatchGetAssetPropertyValueErrorCode =
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueErrorCode
        .wrap(impl.errorCode())
    override val errorMessage: ErrorMessage =
      zio.aws.iotsitewise.model.primitives.ErrorMessage(impl.errorMessage())
    override val entryId: EntryId =
      zio.aws.iotsitewise.model.primitives.EntryId(impl.entryId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueErrorEntry
  ): zio.aws.iotsitewise.model.BatchGetAssetPropertyValueErrorEntry.ReadOnly =
    new Wrapper(impl)
}
