package zio.aws.iotsitewise.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotsitewise.model.primitives.{
  Timestamp,
  Description,
  Name,
  ARN,
  ID
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class AssociatedAssetsSummary(
    id: ID,
    arn: ARN,
    name: Name,
    assetModelId: ID,
    creationDate: Timestamp,
    lastUpdateDate: Timestamp,
    status: zio.aws.iotsitewise.model.AssetStatus,
    hierarchies: Iterable[zio.aws.iotsitewise.model.AssetHierarchy],
    description: Optional[Description] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.AssociatedAssetsSummary = {
    import AssociatedAssetsSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.AssociatedAssetsSummary
      .builder()
      .id(ID.unwrap(id): java.lang.String)
      .arn(ARN.unwrap(arn): java.lang.String)
      .name(Name.unwrap(name): java.lang.String)
      .assetModelId(ID.unwrap(assetModelId): java.lang.String)
      .creationDate(Timestamp.unwrap(creationDate): Instant)
      .lastUpdateDate(Timestamp.unwrap(lastUpdateDate): Instant)
      .status(status.buildAwsValue())
      .hierarchies(hierarchies.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.AssociatedAssetsSummary.ReadOnly =
    zio.aws.iotsitewise.model.AssociatedAssetsSummary.wrap(buildAwsValue())
}
object AssociatedAssetsSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.AssociatedAssetsSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.AssociatedAssetsSummary =
      zio.aws.iotsitewise.model.AssociatedAssetsSummary(
        id,
        arn,
        name,
        assetModelId,
        creationDate,
        lastUpdateDate,
        status.asEditable,
        hierarchies.map { item =>
          item.asEditable
        },
        description.map(value => value)
      )
    def id: ID
    def arn: ARN
    def name: Name
    def assetModelId: ID
    def creationDate: Timestamp
    def lastUpdateDate: Timestamp
    def status: zio.aws.iotsitewise.model.AssetStatus.ReadOnly
    def hierarchies: List[zio.aws.iotsitewise.model.AssetHierarchy.ReadOnly]
    def description: Optional[Description]
    def getId: ZIO[Any, Nothing, ID] = ZIO.succeed(id)
    def getArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(arn)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getAssetModelId: ZIO[Any, Nothing, ID] = ZIO.succeed(assetModelId)
    def getCreationDate: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationDate)
    def getLastUpdateDate: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastUpdateDate)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.AssetStatus.ReadOnly] =
      ZIO.succeed(status)
    def getHierarchies: ZIO[Any, Nothing, List[
      zio.aws.iotsitewise.model.AssetHierarchy.ReadOnly
    ]] = ZIO.succeed(hierarchies)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.AssociatedAssetsSummary
  ) extends zio.aws.iotsitewise.model.AssociatedAssetsSummary.ReadOnly {
    override val id: ID = zio.aws.iotsitewise.model.primitives.ID(impl.id())
    override val arn: ARN = zio.aws.iotsitewise.model.primitives.ARN(impl.arn())
    override val name: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.name())
    override val assetModelId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.assetModelId())
    override val creationDate: Timestamp =
      zio.aws.iotsitewise.model.primitives.Timestamp(impl.creationDate())
    override val lastUpdateDate: Timestamp =
      zio.aws.iotsitewise.model.primitives.Timestamp(impl.lastUpdateDate())
    override val status: zio.aws.iotsitewise.model.AssetStatus.ReadOnly =
      zio.aws.iotsitewise.model.AssetStatus.wrap(impl.status())
    override val hierarchies
        : List[zio.aws.iotsitewise.model.AssetHierarchy.ReadOnly] = impl
      .hierarchies()
      .asScala
      .map { item =>
        zio.aws.iotsitewise.model.AssetHierarchy.wrap(item)
      }
      .toList
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iotsitewise.model.primitives.Description(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.AssociatedAssetsSummary
  ): zio.aws.iotsitewise.model.AssociatedAssetsSummary.ReadOnly = new Wrapper(
    impl
  )
}
