package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{PropertyUnit, PropertyAlias, ID}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssetPropertySummary(
    id: Optional[ID] = Optional.Absent,
    alias: Optional[PropertyAlias] = Optional.Absent,
    unit: Optional[PropertyUnit] = Optional.Absent,
    notification: Optional[zio.aws.iotsitewise.model.PropertyNotification] =
      Optional.Absent,
    assetCompositeModelId: Optional[ID] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.AssetPropertySummary = {
    import AssetPropertySummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.AssetPropertySummary
      .builder()
      .optionallyWith(id.map(value => ID.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(
        alias.map(value => PropertyAlias.unwrap(value): java.lang.String)
      )(_.alias)
      .optionallyWith(
        unit.map(value => PropertyUnit.unwrap(value): java.lang.String)
      )(_.unit)
      .optionallyWith(notification.map(value => value.buildAwsValue()))(
        _.notification
      )
      .optionallyWith(
        assetCompositeModelId.map(value => ID.unwrap(value): java.lang.String)
      )(_.assetCompositeModelId)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.AssetPropertySummary.ReadOnly =
    zio.aws.iotsitewise.model.AssetPropertySummary.wrap(buildAwsValue())
}
object AssetPropertySummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.AssetPropertySummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.AssetPropertySummary =
      zio.aws.iotsitewise.model.AssetPropertySummary(
        id.map(value => value),
        alias.map(value => value),
        unit.map(value => value),
        notification.map(value => value.asEditable),
        assetCompositeModelId.map(value => value)
      )
    def id: Optional[ID]
    def alias: Optional[PropertyAlias]
    def unit: Optional[PropertyUnit]
    def notification
        : Optional[zio.aws.iotsitewise.model.PropertyNotification.ReadOnly]
    def assetCompositeModelId: Optional[ID]
    def getId: ZIO[Any, AwsError, ID] = AwsError.unwrapOptionField("id", id)
    def getAlias: ZIO[Any, AwsError, PropertyAlias] =
      AwsError.unwrapOptionField("alias", alias)
    def getUnit: ZIO[Any, AwsError, PropertyUnit] =
      AwsError.unwrapOptionField("unit", unit)
    def getNotification: ZIO[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.PropertyNotification.ReadOnly
    ] = AwsError.unwrapOptionField("notification", notification)
    def getAssetCompositeModelId: ZIO[Any, AwsError, ID] =
      AwsError.unwrapOptionField("assetCompositeModelId", assetCompositeModelId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.AssetPropertySummary
  ) extends zio.aws.iotsitewise.model.AssetPropertySummary.ReadOnly {
    override val id: Optional[ID] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.iotsitewise.model.primitives.ID(value))
    override val alias: Optional[PropertyAlias] = zio.aws.core.internal
      .optionalFromNullable(impl.alias())
      .map(value => zio.aws.iotsitewise.model.primitives.PropertyAlias(value))
    override val unit: Optional[PropertyUnit] = zio.aws.core.internal
      .optionalFromNullable(impl.unit())
      .map(value => zio.aws.iotsitewise.model.primitives.PropertyUnit(value))
    override val notification
        : Optional[zio.aws.iotsitewise.model.PropertyNotification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notification())
        .map(value =>
          zio.aws.iotsitewise.model.PropertyNotification.wrap(value)
        )
    override val assetCompositeModelId: Optional[ID] = zio.aws.core.internal
      .optionalFromNullable(impl.assetCompositeModelId())
      .map(value => zio.aws.iotsitewise.model.primitives.ID(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.AssetPropertySummary
  ): zio.aws.iotsitewise.model.AssetPropertySummary.ReadOnly = new Wrapper(impl)
}
