package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.VariableName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ExpressionVariable(
    name: VariableName,
    value: zio.aws.iotsitewise.model.VariableValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.ExpressionVariable = {
    import ExpressionVariable.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.ExpressionVariable
      .builder()
      .name(VariableName.unwrap(name): java.lang.String)
      .value(value.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.ExpressionVariable.ReadOnly =
    zio.aws.iotsitewise.model.ExpressionVariable.wrap(buildAwsValue())
}
object ExpressionVariable {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.ExpressionVariable
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.ExpressionVariable =
      zio.aws.iotsitewise.model.ExpressionVariable(name, value.asEditable)
    def name: VariableName
    def value: zio.aws.iotsitewise.model.VariableValue.ReadOnly
    def getName: ZIO[Any, Nothing, VariableName] = ZIO.succeed(name)
    def getValue
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.VariableValue.ReadOnly] =
      ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.ExpressionVariable
  ) extends zio.aws.iotsitewise.model.ExpressionVariable.ReadOnly {
    override val name: VariableName =
      zio.aws.iotsitewise.model.primitives.VariableName(impl.name())
    override val value: zio.aws.iotsitewise.model.VariableValue.ReadOnly =
      zio.aws.iotsitewise.model.VariableValue.wrap(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.ExpressionVariable
  ): zio.aws.iotsitewise.model.ExpressionVariable.ReadOnly = new Wrapper(impl)
}
