package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{Name, ID}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeAssetPropertyResponse(
    assetId: ID,
    assetName: Name,
    assetModelId: ID,
    assetProperty: Optional[zio.aws.iotsitewise.model.Property] =
      Optional.Absent,
    compositeModel: Optional[zio.aws.iotsitewise.model.CompositeModelProperty] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.DescribeAssetPropertyResponse = {
    import DescribeAssetPropertyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.DescribeAssetPropertyResponse
      .builder()
      .assetId(ID.unwrap(assetId): java.lang.String)
      .assetName(Name.unwrap(assetName): java.lang.String)
      .assetModelId(ID.unwrap(assetModelId): java.lang.String)
      .optionallyWith(assetProperty.map(value => value.buildAwsValue()))(
        _.assetProperty
      )
      .optionallyWith(compositeModel.map(value => value.buildAwsValue()))(
        _.compositeModel
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.DescribeAssetPropertyResponse.ReadOnly =
    zio.aws.iotsitewise.model.DescribeAssetPropertyResponse
      .wrap(buildAwsValue())
}
object DescribeAssetPropertyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.DescribeAssetPropertyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.DescribeAssetPropertyResponse =
      zio.aws.iotsitewise.model.DescribeAssetPropertyResponse(
        assetId,
        assetName,
        assetModelId,
        assetProperty.map(value => value.asEditable),
        compositeModel.map(value => value.asEditable)
      )
    def assetId: ID
    def assetName: Name
    def assetModelId: ID
    def assetProperty: Optional[zio.aws.iotsitewise.model.Property.ReadOnly]
    def compositeModel
        : Optional[zio.aws.iotsitewise.model.CompositeModelProperty.ReadOnly]
    def getAssetId: ZIO[Any, Nothing, ID] = ZIO.succeed(assetId)
    def getAssetName: ZIO[Any, Nothing, Name] = ZIO.succeed(assetName)
    def getAssetModelId: ZIO[Any, Nothing, ID] = ZIO.succeed(assetModelId)
    def getAssetProperty
        : ZIO[Any, AwsError, zio.aws.iotsitewise.model.Property.ReadOnly] =
      AwsError.unwrapOptionField("assetProperty", assetProperty)
    def getCompositeModel: ZIO[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.CompositeModelProperty.ReadOnly
    ] = AwsError.unwrapOptionField("compositeModel", compositeModel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeAssetPropertyResponse
  ) extends zio.aws.iotsitewise.model.DescribeAssetPropertyResponse.ReadOnly {
    override val assetId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.assetId())
    override val assetName: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.assetName())
    override val assetModelId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.assetModelId())
    override val assetProperty
        : Optional[zio.aws.iotsitewise.model.Property.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assetProperty())
        .map(value => zio.aws.iotsitewise.model.Property.wrap(value))
    override val compositeModel
        : Optional[zio.aws.iotsitewise.model.CompositeModelProperty.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compositeModel())
        .map(value =>
          zio.aws.iotsitewise.model.CompositeModelProperty.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeAssetPropertyResponse
  ): zio.aws.iotsitewise.model.DescribeAssetPropertyResponse.ReadOnly =
    new Wrapper(impl)
}
