package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{Timestamp, ARN, ID}
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DescribeAccessPolicyResponse(
    accessPolicyId: ID,
    accessPolicyArn: ARN,
    accessPolicyIdentity: zio.aws.iotsitewise.model.Identity,
    accessPolicyResource: zio.aws.iotsitewise.model.Resource,
    accessPolicyPermission: zio.aws.iotsitewise.model.Permission,
    accessPolicyCreationDate: Timestamp,
    accessPolicyLastUpdateDate: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.DescribeAccessPolicyResponse = {
    import DescribeAccessPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.DescribeAccessPolicyResponse
      .builder()
      .accessPolicyId(ID.unwrap(accessPolicyId): java.lang.String)
      .accessPolicyArn(ARN.unwrap(accessPolicyArn): java.lang.String)
      .accessPolicyIdentity(accessPolicyIdentity.buildAwsValue())
      .accessPolicyResource(accessPolicyResource.buildAwsValue())
      .accessPolicyPermission(accessPolicyPermission.unwrap)
      .accessPolicyCreationDate(
        Timestamp.unwrap(accessPolicyCreationDate): Instant
      )
      .accessPolicyLastUpdateDate(
        Timestamp.unwrap(accessPolicyLastUpdateDate): Instant
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.DescribeAccessPolicyResponse.ReadOnly =
    zio.aws.iotsitewise.model.DescribeAccessPolicyResponse.wrap(buildAwsValue())
}
object DescribeAccessPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.DescribeAccessPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.DescribeAccessPolicyResponse =
      zio.aws.iotsitewise.model.DescribeAccessPolicyResponse(
        accessPolicyId,
        accessPolicyArn,
        accessPolicyIdentity.asEditable,
        accessPolicyResource.asEditable,
        accessPolicyPermission,
        accessPolicyCreationDate,
        accessPolicyLastUpdateDate
      )
    def accessPolicyId: ID
    def accessPolicyArn: ARN
    def accessPolicyIdentity: zio.aws.iotsitewise.model.Identity.ReadOnly
    def accessPolicyResource: zio.aws.iotsitewise.model.Resource.ReadOnly
    def accessPolicyPermission: zio.aws.iotsitewise.model.Permission
    def accessPolicyCreationDate: Timestamp
    def accessPolicyLastUpdateDate: Timestamp
    def getAccessPolicyId: ZIO[Any, Nothing, ID] = ZIO.succeed(accessPolicyId)
    def getAccessPolicyArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(accessPolicyArn)
    def getAccessPolicyIdentity
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.Identity.ReadOnly] =
      ZIO.succeed(accessPolicyIdentity)
    def getAccessPolicyResource
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.Resource.ReadOnly] =
      ZIO.succeed(accessPolicyResource)
    def getAccessPolicyPermission
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.Permission] =
      ZIO.succeed(accessPolicyPermission)
    def getAccessPolicyCreationDate: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(accessPolicyCreationDate)
    def getAccessPolicyLastUpdateDate: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(accessPolicyLastUpdateDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeAccessPolicyResponse
  ) extends zio.aws.iotsitewise.model.DescribeAccessPolicyResponse.ReadOnly {
    override val accessPolicyId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.accessPolicyId())
    override val accessPolicyArn: ARN =
      zio.aws.iotsitewise.model.primitives.ARN(impl.accessPolicyArn())
    override val accessPolicyIdentity
        : zio.aws.iotsitewise.model.Identity.ReadOnly =
      zio.aws.iotsitewise.model.Identity.wrap(impl.accessPolicyIdentity())
    override val accessPolicyResource
        : zio.aws.iotsitewise.model.Resource.ReadOnly =
      zio.aws.iotsitewise.model.Resource.wrap(impl.accessPolicyResource())
    override val accessPolicyPermission: zio.aws.iotsitewise.model.Permission =
      zio.aws.iotsitewise.model.Permission.wrap(impl.accessPolicyPermission())
    override val accessPolicyCreationDate: Timestamp =
      zio.aws.iotsitewise.model.primitives
        .Timestamp(impl.accessPolicyCreationDate())
    override val accessPolicyLastUpdateDate: Timestamp =
      zio.aws.iotsitewise.model.primitives
        .Timestamp(impl.accessPolicyLastUpdateDate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeAccessPolicyResponse
  ): zio.aws.iotsitewise.model.DescribeAccessPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
