package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{ARN, ID}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateAssetResponse(
    assetId: ID,
    assetArn: ARN,
    assetStatus: zio.aws.iotsitewise.model.AssetStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.CreateAssetResponse = {
    import CreateAssetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.CreateAssetResponse
      .builder()
      .assetId(ID.unwrap(assetId): java.lang.String)
      .assetArn(ARN.unwrap(assetArn): java.lang.String)
      .assetStatus(assetStatus.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.CreateAssetResponse.ReadOnly =
    zio.aws.iotsitewise.model.CreateAssetResponse.wrap(buildAwsValue())
}
object CreateAssetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.CreateAssetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.CreateAssetResponse =
      zio.aws.iotsitewise.model
        .CreateAssetResponse(assetId, assetArn, assetStatus.asEditable)
    def assetId: ID
    def assetArn: ARN
    def assetStatus: zio.aws.iotsitewise.model.AssetStatus.ReadOnly
    def getAssetId: ZIO[Any, Nothing, ID] = ZIO.succeed(assetId)
    def getAssetArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(assetArn)
    def getAssetStatus
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.AssetStatus.ReadOnly] =
      ZIO.succeed(assetStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.CreateAssetResponse
  ) extends zio.aws.iotsitewise.model.CreateAssetResponse.ReadOnly {
    override val assetId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.assetId())
    override val assetArn: ARN =
      zio.aws.iotsitewise.model.primitives.ARN(impl.assetArn())
    override val assetStatus: zio.aws.iotsitewise.model.AssetStatus.ReadOnly =
      zio.aws.iotsitewise.model.AssetStatus.wrap(impl.assetStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.CreateAssetResponse
  ): zio.aws.iotsitewise.model.CreateAssetResponse.ReadOnly = new Wrapper(impl)
}
