package zio.aws.iotsitewise.model
import scala.jdk.CollectionConverters._
sealed trait ConfigurationState {
  def unwrap
      : software.amazon.awssdk.services.iotsitewise.model.ConfigurationState
}
object ConfigurationState {
  def wrap(
      value: software.amazon.awssdk.services.iotsitewise.model.ConfigurationState
  ): zio.aws.iotsitewise.model.ConfigurationState = value match {
    case software.amazon.awssdk.services.iotsitewise.model.ConfigurationState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotsitewise.model.ConfigurationState.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.iotsitewise.model.ConfigurationState.UPDATE_IN_PROGRESS =>
      val r = UPDATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.iotsitewise.model.ConfigurationState.UPDATE_FAILED =>
      val r = UPDATE_FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotsitewise.model.ConfigurationState {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.ConfigurationState =
      software.amazon.awssdk.services.iotsitewise.model.ConfigurationState.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.iotsitewise.model.ConfigurationState {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.ConfigurationState =
      software.amazon.awssdk.services.iotsitewise.model.ConfigurationState.ACTIVE
  }
  case object UPDATE_IN_PROGRESS
      extends zio.aws.iotsitewise.model.ConfigurationState {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.ConfigurationState =
      software.amazon.awssdk.services.iotsitewise.model.ConfigurationState.UPDATE_IN_PROGRESS
  }
  case object UPDATE_FAILED
      extends zio.aws.iotsitewise.model.ConfigurationState {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.ConfigurationState =
      software.amazon.awssdk.services.iotsitewise.model.ConfigurationState.UPDATE_FAILED
  }
}
