package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchPutAssetPropertyValueResponse(
    errorEntries: Iterable[
      zio.aws.iotsitewise.model.BatchPutAssetPropertyErrorEntry
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueResponse = {
    import BatchPutAssetPropertyValueResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueResponse
      .builder()
      .errorEntries(errorEntries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.BatchPutAssetPropertyValueResponse.ReadOnly =
    zio.aws.iotsitewise.model.BatchPutAssetPropertyValueResponse
      .wrap(buildAwsValue())
}
object BatchPutAssetPropertyValueResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotsitewise.model.BatchPutAssetPropertyValueResponse =
      zio.aws.iotsitewise.model
        .BatchPutAssetPropertyValueResponse(errorEntries.map { item =>
          item.asEditable
        })
    def errorEntries: List[
      zio.aws.iotsitewise.model.BatchPutAssetPropertyErrorEntry.ReadOnly
    ]
    def getErrorEntries: ZIO[Any, Nothing, List[
      zio.aws.iotsitewise.model.BatchPutAssetPropertyErrorEntry.ReadOnly
    ]] = ZIO.succeed(errorEntries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueResponse
  ) extends zio.aws.iotsitewise.model.BatchPutAssetPropertyValueResponse.ReadOnly {
    override val errorEntries: List[
      zio.aws.iotsitewise.model.BatchPutAssetPropertyErrorEntry.ReadOnly
    ] = impl
      .errorEntries()
      .asScala
      .map { item =>
        zio.aws.iotsitewise.model.BatchPutAssetPropertyErrorEntry.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueResponse
  ): zio.aws.iotsitewise.model.BatchPutAssetPropertyValueResponse.ReadOnly =
    new Wrapper(impl)
}
