package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{ClientToken, Name, ID}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateAssetRequest(
    assetId: ID,
    assetName: Name,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.UpdateAssetRequest = {
    import UpdateAssetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.UpdateAssetRequest
      .builder()
      .assetId(ID.unwrap(assetId): java.lang.String)
      .assetName(Name.unwrap(assetName): java.lang.String)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.UpdateAssetRequest.ReadOnly =
    zio.aws.iotsitewise.model.UpdateAssetRequest.wrap(buildAwsValue())
}
object UpdateAssetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.UpdateAssetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.UpdateAssetRequest =
      zio.aws.iotsitewise.model
        .UpdateAssetRequest(assetId, assetName, clientToken.map(value => value))
    def assetId: ID
    def assetName: Name
    def clientToken: Optional[ClientToken]
    def getAssetId: ZIO[Any, Nothing, ID] = ZIO.succeed(assetId)
    def getAssetName: ZIO[Any, Nothing, Name] = ZIO.succeed(assetName)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.UpdateAssetRequest
  ) extends zio.aws.iotsitewise.model.UpdateAssetRequest.ReadOnly {
    override val assetId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.assetId())
    override val assetName: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.assetName())
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.iotsitewise.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.UpdateAssetRequest
  ): zio.aws.iotsitewise.model.UpdateAssetRequest.ReadOnly = new Wrapper(impl)
}
