package zio.aws.iotsitewise.model
import scala.jdk.CollectionConverters._
sealed trait MonitorErrorCode {
  def unwrap: software.amazon.awssdk.services.iotsitewise.model.MonitorErrorCode
}
object MonitorErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.iotsitewise.model.MonitorErrorCode
  ): zio.aws.iotsitewise.model.MonitorErrorCode = value match {
    case software.amazon.awssdk.services.iotsitewise.model.MonitorErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotsitewise.model.MonitorErrorCode.INTERNAL_FAILURE =>
      val r = INTERNAL_FAILURE
      r
    case software.amazon.awssdk.services.iotsitewise.model.MonitorErrorCode.VALIDATION_ERROR =>
      val r = VALIDATION_ERROR
      r
    case software.amazon.awssdk.services.iotsitewise.model.MonitorErrorCode.LIMIT_EXCEEDED =>
      val r = LIMIT_EXCEEDED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotsitewise.model.MonitorErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.MonitorErrorCode =
      software.amazon.awssdk.services.iotsitewise.model.MonitorErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object INTERNAL_FAILURE
      extends zio.aws.iotsitewise.model.MonitorErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.MonitorErrorCode =
      software.amazon.awssdk.services.iotsitewise.model.MonitorErrorCode.INTERNAL_FAILURE
  }
  case object VALIDATION_ERROR
      extends zio.aws.iotsitewise.model.MonitorErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.MonitorErrorCode =
      software.amazon.awssdk.services.iotsitewise.model.MonitorErrorCode.VALIDATION_ERROR
  }
  case object LIMIT_EXCEEDED
      extends zio.aws.iotsitewise.model.MonitorErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.MonitorErrorCode =
      software.amazon.awssdk.services.iotsitewise.model.MonitorErrorCode.LIMIT_EXCEEDED
  }
}
