package zio.aws.iotsitewise.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotsitewise.model.primitives.{Timestamp, Name, ARN, ID}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeAssetResponse(
    assetId: ID,
    assetArn: ARN,
    assetName: Name,
    assetModelId: ID,
    assetProperties: Iterable[zio.aws.iotsitewise.model.AssetProperty],
    assetHierarchies: Iterable[zio.aws.iotsitewise.model.AssetHierarchy],
    assetCompositeModels: Optional[
      Iterable[zio.aws.iotsitewise.model.AssetCompositeModel]
    ] = Optional.Absent,
    assetCreationDate: Timestamp,
    assetLastUpdateDate: Timestamp,
    assetStatus: zio.aws.iotsitewise.model.AssetStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.DescribeAssetResponse = {
    import DescribeAssetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.DescribeAssetResponse
      .builder()
      .assetId(ID.unwrap(assetId): java.lang.String)
      .assetArn(ARN.unwrap(assetArn): java.lang.String)
      .assetName(Name.unwrap(assetName): java.lang.String)
      .assetModelId(ID.unwrap(assetModelId): java.lang.String)
      .assetProperties(assetProperties.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .assetHierarchies(assetHierarchies.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        assetCompositeModels.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.assetCompositeModels)
      .assetCreationDate(Timestamp.unwrap(assetCreationDate): Instant)
      .assetLastUpdateDate(Timestamp.unwrap(assetLastUpdateDate): Instant)
      .assetStatus(assetStatus.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.DescribeAssetResponse.ReadOnly =
    zio.aws.iotsitewise.model.DescribeAssetResponse.wrap(buildAwsValue())
}
object DescribeAssetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.DescribeAssetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.DescribeAssetResponse =
      zio.aws.iotsitewise.model.DescribeAssetResponse(
        assetId,
        assetArn,
        assetName,
        assetModelId,
        assetProperties.map { item =>
          item.asEditable
        },
        assetHierarchies.map { item =>
          item.asEditable
        },
        assetCompositeModels.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        assetCreationDate,
        assetLastUpdateDate,
        assetStatus.asEditable
      )
    def assetId: ID
    def assetArn: ARN
    def assetName: Name
    def assetModelId: ID
    def assetProperties: List[zio.aws.iotsitewise.model.AssetProperty.ReadOnly]
    def assetHierarchies
        : List[zio.aws.iotsitewise.model.AssetHierarchy.ReadOnly]
    def assetCompositeModels
        : Optional[List[zio.aws.iotsitewise.model.AssetCompositeModel.ReadOnly]]
    def assetCreationDate: Timestamp
    def assetLastUpdateDate: Timestamp
    def assetStatus: zio.aws.iotsitewise.model.AssetStatus.ReadOnly
    def getAssetId: ZIO[Any, Nothing, ID] = ZIO.succeed(assetId)
    def getAssetArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(assetArn)
    def getAssetName: ZIO[Any, Nothing, Name] = ZIO.succeed(assetName)
    def getAssetModelId: ZIO[Any, Nothing, ID] = ZIO.succeed(assetModelId)
    def getAssetProperties: ZIO[Any, Nothing, List[
      zio.aws.iotsitewise.model.AssetProperty.ReadOnly
    ]] = ZIO.succeed(assetProperties)
    def getAssetHierarchies: ZIO[Any, Nothing, List[
      zio.aws.iotsitewise.model.AssetHierarchy.ReadOnly
    ]] = ZIO.succeed(assetHierarchies)
    def getAssetCompositeModels: ZIO[Any, AwsError, List[
      zio.aws.iotsitewise.model.AssetCompositeModel.ReadOnly
    ]] =
      AwsError.unwrapOptionField("assetCompositeModels", assetCompositeModels)
    def getAssetCreationDate: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(assetCreationDate)
    def getAssetLastUpdateDate: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(assetLastUpdateDate)
    def getAssetStatus
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.AssetStatus.ReadOnly] =
      ZIO.succeed(assetStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeAssetResponse
  ) extends zio.aws.iotsitewise.model.DescribeAssetResponse.ReadOnly {
    override val assetId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.assetId())
    override val assetArn: ARN =
      zio.aws.iotsitewise.model.primitives.ARN(impl.assetArn())
    override val assetName: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.assetName())
    override val assetModelId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.assetModelId())
    override val assetProperties
        : List[zio.aws.iotsitewise.model.AssetProperty.ReadOnly] = impl
      .assetProperties()
      .asScala
      .map { item =>
        zio.aws.iotsitewise.model.AssetProperty.wrap(item)
      }
      .toList
    override val assetHierarchies
        : List[zio.aws.iotsitewise.model.AssetHierarchy.ReadOnly] = impl
      .assetHierarchies()
      .asScala
      .map { item =>
        zio.aws.iotsitewise.model.AssetHierarchy.wrap(item)
      }
      .toList
    override val assetCompositeModels: Optional[
      List[zio.aws.iotsitewise.model.AssetCompositeModel.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.assetCompositeModels())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotsitewise.model.AssetCompositeModel.wrap(item)
        }.toList
      )
    override val assetCreationDate: Timestamp =
      zio.aws.iotsitewise.model.primitives.Timestamp(impl.assetCreationDate())
    override val assetLastUpdateDate: Timestamp =
      zio.aws.iotsitewise.model.primitives.Timestamp(impl.assetLastUpdateDate())
    override val assetStatus: zio.aws.iotsitewise.model.AssetStatus.ReadOnly =
      zio.aws.iotsitewise.model.AssetStatus.wrap(impl.assetStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeAssetResponse
  ): zio.aws.iotsitewise.model.DescribeAssetResponse.ReadOnly = new Wrapper(
    impl
  )
}
