package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchGetAssetPropertyValueResponse(
    errorEntries: Iterable[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueErrorEntry
    ],
    successEntries: Iterable[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueSuccessEntry
    ],
    skippedEntries: Iterable[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueSkippedEntry
    ],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueResponse = {
    import BatchGetAssetPropertyValueResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueResponse
      .builder()
      .errorEntries(errorEntries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .successEntries(successEntries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .skippedEntries(skippedEntries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.BatchGetAssetPropertyValueResponse.ReadOnly =
    zio.aws.iotsitewise.model.BatchGetAssetPropertyValueResponse
      .wrap(buildAwsValue())
}
object BatchGetAssetPropertyValueResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotsitewise.model.BatchGetAssetPropertyValueResponse =
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueResponse(
        errorEntries.map { item =>
          item.asEditable
        },
        successEntries.map { item =>
          item.asEditable
        },
        skippedEntries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def errorEntries: List[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueErrorEntry.ReadOnly
    ]
    def successEntries: List[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueSuccessEntry.ReadOnly
    ]
    def skippedEntries: List[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueSkippedEntry.ReadOnly
    ]
    def nextToken: Optional[NextToken]
    def getErrorEntries: ZIO[Any, Nothing, List[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueErrorEntry.ReadOnly
    ]] = ZIO.succeed(errorEntries)
    def getSuccessEntries: ZIO[Any, Nothing, List[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueSuccessEntry.ReadOnly
    ]] = ZIO.succeed(successEntries)
    def getSkippedEntries: ZIO[Any, Nothing, List[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueSkippedEntry.ReadOnly
    ]] = ZIO.succeed(skippedEntries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueResponse
  ) extends zio.aws.iotsitewise.model.BatchGetAssetPropertyValueResponse.ReadOnly {
    override val errorEntries: List[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueErrorEntry.ReadOnly
    ] = impl
      .errorEntries()
      .asScala
      .map { item =>
        zio.aws.iotsitewise.model.BatchGetAssetPropertyValueErrorEntry
          .wrap(item)
      }
      .toList
    override val successEntries: List[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueSuccessEntry.ReadOnly
    ] = impl
      .successEntries()
      .asScala
      .map { item =>
        zio.aws.iotsitewise.model.BatchGetAssetPropertyValueSuccessEntry
          .wrap(item)
      }
      .toList
    override val skippedEntries: List[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueSkippedEntry.ReadOnly
    ] = impl
      .skippedEntries()
      .asScala
      .map { item =>
        zio.aws.iotsitewise.model.BatchGetAssetPropertyValueSkippedEntry
          .wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotsitewise.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueResponse
  ): zio.aws.iotsitewise.model.BatchGetAssetPropertyValueResponse.ReadOnly =
    new Wrapper(impl)
}
