package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchGetAssetPropertyValueHistoryResponse(
    errorEntries: Iterable[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorEntry
    ],
    successEntries: Iterable[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistorySuccessEntry
    ],
    skippedEntries: Iterable[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistorySkippedEntry
    ],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryResponse = {
    import BatchGetAssetPropertyValueHistoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryResponse
      .builder()
      .errorEntries(errorEntries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .successEntries(successEntries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .skippedEntries(skippedEntries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryResponse.ReadOnly =
    zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryResponse
      .wrap(buildAwsValue())
}
object BatchGetAssetPropertyValueHistoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryResponse =
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryResponse(
        errorEntries.map { item =>
          item.asEditable
        },
        successEntries.map { item =>
          item.asEditable
        },
        skippedEntries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def errorEntries: List[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorEntry.ReadOnly
    ]
    def successEntries: List[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistorySuccessEntry.ReadOnly
    ]
    def skippedEntries: List[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistorySkippedEntry.ReadOnly
    ]
    def nextToken: Optional[NextToken]
    def getErrorEntries: ZIO[Any, Nothing, List[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorEntry.ReadOnly
    ]] = ZIO.succeed(errorEntries)
    def getSuccessEntries: ZIO[Any, Nothing, List[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistorySuccessEntry.ReadOnly
    ]] = ZIO.succeed(successEntries)
    def getSkippedEntries: ZIO[Any, Nothing, List[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistorySkippedEntry.ReadOnly
    ]] = ZIO.succeed(skippedEntries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryResponse
  ) extends zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryResponse.ReadOnly {
    override val errorEntries: List[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorEntry.ReadOnly
    ] = impl
      .errorEntries()
      .asScala
      .map { item =>
        zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorEntry
          .wrap(item)
      }
      .toList
    override val successEntries: List[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistorySuccessEntry.ReadOnly
    ] = impl
      .successEntries()
      .asScala
      .map { item =>
        zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistorySuccessEntry
          .wrap(item)
      }
      .toList
    override val skippedEntries: List[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistorySkippedEntry.ReadOnly
    ] = impl
      .skippedEntries()
      .asScala
      .map { item =>
        zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistorySkippedEntry
          .wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotsitewise.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryResponse
  ): zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryResponse.ReadOnly =
    new Wrapper(impl)
}
