package zio.aws.iotsitewise.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotsitewise.model.primitives.{
  BatchGetAssetPropertyValueHistoryMaxResults,
  NextToken
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class BatchGetAssetPropertyValueHistoryRequest(
    entries: Iterable[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryEntry
    ],
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[BatchGetAssetPropertyValueHistoryMaxResults] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryRequest = {
    import BatchGetAssetPropertyValueHistoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryRequest
      .builder()
      .entries(entries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          BatchGetAssetPropertyValueHistoryMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryRequest.ReadOnly =
    zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryRequest
      .wrap(buildAwsValue())
}
object BatchGetAssetPropertyValueHistoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryRequest =
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryRequest(
        entries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def entries: List[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryEntry.ReadOnly
    ]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[BatchGetAssetPropertyValueHistoryMaxResults]
    def getEntries: ZIO[Any, Nothing, List[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryEntry.ReadOnly
    ]] = ZIO.succeed(entries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults
        : ZIO[Any, AwsError, BatchGetAssetPropertyValueHistoryMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryRequest
  ) extends zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryRequest.ReadOnly {
    override val entries: List[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryEntry.ReadOnly
    ] = impl
      .entries()
      .asScala
      .map { item =>
        zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryEntry
          .wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotsitewise.model.primitives.NextToken(value))
    override val maxResults
        : Optional[BatchGetAssetPropertyValueHistoryMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.iotsitewise.model.primitives
            .BatchGetAssetPropertyValueHistoryMaxResults(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryRequest
  ): zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryRequest.ReadOnly =
    new Wrapper(impl)
}
