package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchDisassociateProjectAssetsResponse(
    errors: Optional[Iterable[zio.aws.iotsitewise.model.AssetErrorDetails]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.BatchDisassociateProjectAssetsResponse = {
    import BatchDisassociateProjectAssetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.BatchDisassociateProjectAssetsResponse
      .builder()
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.BatchDisassociateProjectAssetsResponse.ReadOnly =
    zio.aws.iotsitewise.model.BatchDisassociateProjectAssetsResponse
      .wrap(buildAwsValue())
}
object BatchDisassociateProjectAssetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.BatchDisassociateProjectAssetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotsitewise.model.BatchDisassociateProjectAssetsResponse =
      zio.aws.iotsitewise.model.BatchDisassociateProjectAssetsResponse(
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def errors
        : Optional[List[zio.aws.iotsitewise.model.AssetErrorDetails.ReadOnly]]
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.iotsitewise.model.AssetErrorDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchDisassociateProjectAssetsResponse
  ) extends zio.aws.iotsitewise.model.BatchDisassociateProjectAssetsResponse.ReadOnly {
    override val errors
        : Optional[List[zio.aws.iotsitewise.model.AssetErrorDetails.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotsitewise.model.AssetErrorDetails.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchDisassociateProjectAssetsResponse
  ): zio.aws.iotsitewise.model.BatchDisassociateProjectAssetsResponse.ReadOnly =
    new Wrapper(impl)
}
