package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{ClientToken, ID}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchAssociateProjectAssetsRequest(
    projectId: ID,
    assetIds: Iterable[ID],
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.BatchAssociateProjectAssetsRequest = {
    import BatchAssociateProjectAssetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.BatchAssociateProjectAssetsRequest
      .builder()
      .projectId(ID.unwrap(projectId): java.lang.String)
      .assetIds(assetIds.map { item =>
        ID.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.BatchAssociateProjectAssetsRequest.ReadOnly =
    zio.aws.iotsitewise.model.BatchAssociateProjectAssetsRequest
      .wrap(buildAwsValue())
}
object BatchAssociateProjectAssetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.BatchAssociateProjectAssetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotsitewise.model.BatchAssociateProjectAssetsRequest =
      zio.aws.iotsitewise.model.BatchAssociateProjectAssetsRequest(
        projectId,
        assetIds,
        clientToken.map(value => value)
      )
    def projectId: ID
    def assetIds: List[ID]
    def clientToken: Optional[ClientToken]
    def getProjectId: ZIO[Any, Nothing, ID] = ZIO.succeed(projectId)
    def getAssetIds: ZIO[Any, Nothing, List[ID]] = ZIO.succeed(assetIds)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchAssociateProjectAssetsRequest
  ) extends zio.aws.iotsitewise.model.BatchAssociateProjectAssetsRequest.ReadOnly {
    override val projectId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.projectId())
    override val assetIds: List[ID] = impl
      .assetIds()
      .asScala
      .map { item =>
        zio.aws.iotsitewise.model.primitives.ID(item)
      }
      .toList
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.iotsitewise.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchAssociateProjectAssetsRequest
  ): zio.aws.iotsitewise.model.BatchAssociateProjectAssetsRequest.ReadOnly =
    new Wrapper(impl)
}
