package zio.aws.iotsitewise
import zio.aws.iotsitewise.model.AssociatedAssetsSummary.ReadOnly
import software.amazon.awssdk.services.iotsitewise.{
  IoTSiteWiseAsyncClientBuilder,
  IoTSiteWiseAsyncClient
}
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.iotsitewise.model.{
  DeleteGatewayRequest,
  DeleteAssetRequest,
  DescribeProjectResponse,
  UpdateAssetResponse,
  DescribeLoggingOptionsRequest,
  AccessPolicySummary,
  DescribePortalResponse,
  DescribeDashboardResponse,
  DescribeStorageConfigurationRequest,
  GetAssetPropertyAggregatesRequest,
  GetAssetPropertyValueResponse,
  ListAssociatedAssetsResponse,
  GetAssetPropertyValueHistoryResponse,
  ListPortalsResponse,
  UpdateGatewayResponse,
  PutStorageConfigurationResponse,
  DeleteGatewayResponse,
  AssetPropertyValue,
  DescribeGatewayRequest,
  CreateAccessPolicyRequest,
  CreateProjectRequest,
  ListPortalsRequest,
  ListDashboardsRequest,
  BatchDisassociateProjectAssetsResponse,
  CreateAccessPolicyResponse,
  ListTimeSeriesRequest,
  GetAssetPropertyValueHistoryRequest,
  UpdateAssetModelResponse,
  GetInterpolatedAssetPropertyValuesResponse,
  AssetSummary,
  PutDefaultEncryptionConfigurationResponse,
  DescribeAssetModelResponse,
  BatchPutAssetPropertyValueResponse,
  TimeSeriesSummary,
  DeleteTimeSeriesResponse,
  DeleteAssetModelRequest,
  DescribeTimeSeriesRequest,
  ListProjectsResponse,
  DescribeLoggingOptionsResponse,
  CreateAssetResponse,
  UpdatePortalResponse,
  DeleteAccessPolicyRequest,
  UpdateDashboardRequest,
  ListAssetRelationshipsResponse,
  ListGatewaysResponse,
  ListTagsForResourceRequest,
  ListDashboardsResponse,
  AssociatedAssetsSummary,
  CreateAssetRequest,
  CreatePortalRequest,
  CreateAssetModelRequest,
  BatchGetAssetPropertyAggregatesRequest,
  UpdateGatewayRequest,
  DescribeStorageConfigurationResponse,
  UpdateAccessPolicyResponse,
  DescribeTimeSeriesResponse,
  PortalSummary,
  AssociateTimeSeriesToAssetPropertyRequest,
  UpdateAssetModelRequest,
  DeleteDashboardResponse,
  UpdateProjectRequest,
  ListTagsForResourceResponse,
  AggregatedValue,
  DescribeAccessPolicyResponse,
  UntagResourceResponse,
  DeletePortalRequest,
  AssetModelSummary,
  DeleteProjectRequest,
  DeleteTimeSeriesRequest,
  PutLoggingOptionsResponse,
  ListTimeSeriesResponse,
  DeleteAssetResponse,
  GetAssetPropertyAggregatesResponse,
  CreateProjectResponse,
  DescribeAssetPropertyRequest,
  AssociateAssetsResponse,
  UpdateAssetPropertyRequest,
  DeleteAccessPolicyResponse,
  DeleteAssetModelResponse,
  ListProjectAssetsResponse,
  ListAssetModelsRequest,
  ListAssociatedAssetsRequest,
  BatchGetAssetPropertyValueRequest,
  UpdateAssetRequest,
  DescribeAssetPropertyResponse,
  AssetRelationshipSummary,
  DescribePortalRequest,
  BatchGetAssetPropertyValueHistoryRequest,
  DescribeAccessPolicyRequest,
  DeleteDashboardRequest,
  ListAssetsRequest,
  BatchGetAssetPropertyValueHistoryResponse,
  PutLoggingOptionsRequest,
  BatchGetAssetPropertyValueResponse,
  BatchAssociateProjectAssetsRequest,
  CreatePortalResponse,
  ListProjectsRequest,
  UntagResourceRequest,
  DashboardSummary,
  UpdateGatewayCapabilityConfigurationResponse,
  CreateDashboardRequest,
  DisassociateAssetsResponse,
  UpdateAssetPropertyResponse,
  UpdateDashboardResponse,
  ProjectSummary,
  GetAssetPropertyValueRequest,
  CreateDashboardResponse,
  CreateAssetModelResponse,
  DescribeAssetRequest,
  GatewaySummary,
  ListAssetModelsResponse,
  DescribeAssetModelRequest,
  CreateGatewayRequest,
  InterpolatedAssetPropertyValue,
  ListAccessPoliciesResponse,
  BatchAssociateProjectAssetsResponse,
  DescribeGatewayCapabilityConfigurationRequest,
  BatchPutAssetPropertyValueRequest,
  UpdateGatewayCapabilityConfigurationRequest,
  DescribeDashboardRequest,
  DeletePortalResponse,
  AssociateTimeSeriesToAssetPropertyResponse,
  UpdateProjectResponse,
  ListGatewaysRequest,
  TagResourceResponse,
  UpdatePortalRequest,
  DisassociateAssetsRequest,
  DescribeAssetResponse,
  BatchDisassociateProjectAssetsRequest,
  UpdateAccessPolicyRequest,
  DeleteProjectResponse,
  BatchGetAssetPropertyAggregatesResponse,
  AssociateAssetsRequest,
  CreateGatewayResponse,
  DescribeGatewayResponse,
  DescribeProjectRequest,
  DescribeGatewayCapabilityConfigurationResponse,
  TagResourceRequest,
  DisassociateTimeSeriesFromAssetPropertyResponse,
  DescribeDefaultEncryptionConfigurationResponse,
  ListAssetsResponse,
  GetInterpolatedAssetPropertyValuesRequest,
  PutStorageConfigurationRequest,
  DisassociateTimeSeriesFromAssetPropertyRequest,
  ListAccessPoliciesRequest,
  ListProjectAssetsRequest,
  ListAssetRelationshipsRequest,
  DescribeDefaultEncryptionConfigurationRequest,
  PutDefaultEncryptionConfigurationRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.iotsitewise.model.primitives.ID
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.iotsitewise.paginators.{
  ListAccessPoliciesPublisher,
  GetInterpolatedAssetPropertyValuesPublisher,
  ListAssetsPublisher,
  ListAssetModelsPublisher,
  ListGatewaysPublisher,
  ListDashboardsPublisher,
  ListProjectAssetsPublisher,
  GetAssetPropertyValueHistoryPublisher,
  ListPortalsPublisher,
  ListAssociatedAssetsPublisher,
  ListAssetRelationshipsPublisher,
  ListProjectsPublisher,
  ListTimeSeriesPublisher,
  GetAssetPropertyAggregatesPublisher
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait IoTSiteWise extends AspectSupport[IoTSiteWise] {
  val api: IoTSiteWiseAsyncClient
  def associateAssets(
      request: zio.aws.iotsitewise.model.AssociateAssetsRequest
  ): IO[AwsError, Unit]
  def updateGateway(
      request: zio.aws.iotsitewise.model.UpdateGatewayRequest
  ): IO[AwsError, Unit]
  def createPortal(
      request: zio.aws.iotsitewise.model.CreatePortalRequest
  ): IO[AwsError, zio.aws.iotsitewise.model.CreatePortalResponse.ReadOnly]
  def listPortals(
      request: zio.aws.iotsitewise.model.ListPortalsRequest
  ): ZStream[Any, AwsError, zio.aws.iotsitewise.model.PortalSummary.ReadOnly]
  def listPortalsPaginated(
      request: zio.aws.iotsitewise.model.ListPortalsRequest
  ): IO[AwsError, zio.aws.iotsitewise.model.ListPortalsResponse.ReadOnly]
  def deletePortal(
      request: zio.aws.iotsitewise.model.DeletePortalRequest
  ): IO[AwsError, zio.aws.iotsitewise.model.DeletePortalResponse.ReadOnly]
  def createGateway(
      request: zio.aws.iotsitewise.model.CreateGatewayRequest
  ): IO[AwsError, zio.aws.iotsitewise.model.CreateGatewayResponse.ReadOnly]
  def updateAccessPolicy(
      request: zio.aws.iotsitewise.model.UpdateAccessPolicyRequest
  ): IO[AwsError, zio.aws.iotsitewise.model.UpdateAccessPolicyResponse.ReadOnly]
  def deleteAssetModel(
      request: zio.aws.iotsitewise.model.DeleteAssetModelRequest
  ): IO[AwsError, zio.aws.iotsitewise.model.DeleteAssetModelResponse.ReadOnly]
  def disassociateAssets(
      request: zio.aws.iotsitewise.model.DisassociateAssetsRequest
  ): IO[AwsError, Unit]
  def deleteGateway(
      request: zio.aws.iotsitewise.model.DeleteGatewayRequest
  ): IO[AwsError, Unit]
  def updateProject(
      request: zio.aws.iotsitewise.model.UpdateProjectRequest
  ): IO[AwsError, zio.aws.iotsitewise.model.UpdateProjectResponse.ReadOnly]
  def associateTimeSeriesToAssetProperty(
      request: zio.aws.iotsitewise.model.AssociateTimeSeriesToAssetPropertyRequest
  ): IO[AwsError, Unit]
  def batchAssociateProjectAssets(
      request: zio.aws.iotsitewise.model.BatchAssociateProjectAssetsRequest
  ): IO[
    AwsError,
    zio.aws.iotsitewise.model.BatchAssociateProjectAssetsResponse.ReadOnly
  ]
  def createAccessPolicy(
      request: zio.aws.iotsitewise.model.CreateAccessPolicyRequest
  ): IO[AwsError, zio.aws.iotsitewise.model.CreateAccessPolicyResponse.ReadOnly]
  def describeLoggingOptions(
      request: zio.aws.iotsitewise.model.DescribeLoggingOptionsRequest
  ): IO[
    AwsError,
    zio.aws.iotsitewise.model.DescribeLoggingOptionsResponse.ReadOnly
  ]
  def describeAsset(
      request: zio.aws.iotsitewise.model.DescribeAssetRequest
  ): IO[AwsError, zio.aws.iotsitewise.model.DescribeAssetResponse.ReadOnly]
  def deleteTimeSeries(
      request: zio.aws.iotsitewise.model.DeleteTimeSeriesRequest
  ): IO[AwsError, Unit]
  def putStorageConfiguration(
      request: zio.aws.iotsitewise.model.PutStorageConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.iotsitewise.model.PutStorageConfigurationResponse.ReadOnly
  ]
  def describeAssetModel(
      request: zio.aws.iotsitewise.model.DescribeAssetModelRequest
  ): IO[AwsError, zio.aws.iotsitewise.model.DescribeAssetModelResponse.ReadOnly]
  def listAssets(
      request: zio.aws.iotsitewise.model.ListAssetsRequest
  ): ZStream[Any, AwsError, zio.aws.iotsitewise.model.AssetSummary.ReadOnly]
  def listAssetsPaginated(
      request: zio.aws.iotsitewise.model.ListAssetsRequest
  ): IO[AwsError, zio.aws.iotsitewise.model.ListAssetsResponse.ReadOnly]
  def getInterpolatedAssetPropertyValues(
      request: zio.aws.iotsitewise.model.GetInterpolatedAssetPropertyValuesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.iotsitewise.model.InterpolatedAssetPropertyValue.ReadOnly
  ]
  def getInterpolatedAssetPropertyValuesPaginated(
      request: zio.aws.iotsitewise.model.GetInterpolatedAssetPropertyValuesRequest
  ): IO[
    AwsError,
    zio.aws.iotsitewise.model.GetInterpolatedAssetPropertyValuesResponse.ReadOnly
  ]
  def updateAssetModel(
      request: zio.aws.iotsitewise.model.UpdateAssetModelRequest
  ): IO[AwsError, zio.aws.iotsitewise.model.UpdateAssetModelResponse.ReadOnly]
  def listProjects(
      request: zio.aws.iotsitewise.model.ListProjectsRequest
  ): ZStream[Any, AwsError, zio.aws.iotsitewise.model.ProjectSummary.ReadOnly]
  def listProjectsPaginated(
      request: zio.aws.iotsitewise.model.ListProjectsRequest
  ): IO[AwsError, zio.aws.iotsitewise.model.ListProjectsResponse.ReadOnly]
  def putLoggingOptions(
      request: zio.aws.iotsitewise.model.PutLoggingOptionsRequest
  ): IO[AwsError, zio.aws.iotsitewise.model.PutLoggingOptionsResponse.ReadOnly]
  def deleteAccessPolicy(
      request: zio.aws.iotsitewise.model.DeleteAccessPolicyRequest
  ): IO[AwsError, zio.aws.iotsitewise.model.DeleteAccessPolicyResponse.ReadOnly]
  def listAssetRelationships(
      request: zio.aws.iotsitewise.model.ListAssetRelationshipsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.iotsitewise.model.AssetRelationshipSummary.ReadOnly
  ]
  def listAssetRelationshipsPaginated(
      request: zio.aws.iotsitewise.model.ListAssetRelationshipsRequest
  ): IO[
    AwsError,
    zio.aws.iotsitewise.model.ListAssetRelationshipsResponse.ReadOnly
  ]
  def listDashboards(
      request: zio.aws.iotsitewise.model.ListDashboardsRequest
  ): ZStream[Any, AwsError, zio.aws.iotsitewise.model.DashboardSummary.ReadOnly]
  def listDashboardsPaginated(
      request: zio.aws.iotsitewise.model.ListDashboardsRequest
  ): IO[AwsError, zio.aws.iotsitewise.model.ListDashboardsResponse.ReadOnly]
  def updateDashboard(
      request: zio.aws.iotsitewise.model.UpdateDashboardRequest
  ): IO[AwsError, zio.aws.iotsitewise.model.UpdateDashboardResponse.ReadOnly]
  def listAccessPolicies(
      request: zio.aws.iotsitewise.model.ListAccessPoliciesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.iotsitewise.model.AccessPolicySummary.ReadOnly
  ]
  def listAccessPoliciesPaginated(
      request: zio.aws.iotsitewise.model.ListAccessPoliciesRequest
  ): IO[AwsError, zio.aws.iotsitewise.model.ListAccessPoliciesResponse.ReadOnly]
  def createDashboard(
      request: zio.aws.iotsitewise.model.CreateDashboardRequest
  ): IO[AwsError, zio.aws.iotsitewise.model.CreateDashboardResponse.ReadOnly]
  def createAsset(
      request: zio.aws.iotsitewise.model.CreateAssetRequest
  ): IO[AwsError, zio.aws.iotsitewise.model.CreateAssetResponse.ReadOnly]
  def describeTimeSeries(
      request: zio.aws.iotsitewise.model.DescribeTimeSeriesRequest
  ): IO[AwsError, zio.aws.iotsitewise.model.DescribeTimeSeriesResponse.ReadOnly]
  def untagResource(
      request: zio.aws.iotsitewise.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.iotsitewise.model.UntagResourceResponse.ReadOnly]
  def createProject(
      request: zio.aws.iotsitewise.model.CreateProjectRequest
  ): IO[AwsError, zio.aws.iotsitewise.model.CreateProjectResponse.ReadOnly]
  def describeDefaultEncryptionConfiguration(
      request: zio.aws.iotsitewise.model.DescribeDefaultEncryptionConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.iotsitewise.model.DescribeDefaultEncryptionConfigurationResponse.ReadOnly
  ]
  def describeGateway(
      request: zio.aws.iotsitewise.model.DescribeGatewayRequest
  ): IO[AwsError, zio.aws.iotsitewise.model.DescribeGatewayResponse.ReadOnly]
  def getAssetPropertyValue(
      request: zio.aws.iotsitewise.model.GetAssetPropertyValueRequest
  ): IO[
    AwsError,
    zio.aws.iotsitewise.model.GetAssetPropertyValueResponse.ReadOnly
  ]
  def putDefaultEncryptionConfiguration(
      request: zio.aws.iotsitewise.model.PutDefaultEncryptionConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.iotsitewise.model.PutDefaultEncryptionConfigurationResponse.ReadOnly
  ]
  def describeAccessPolicy(
      request: zio.aws.iotsitewise.model.DescribeAccessPolicyRequest
  ): IO[
    AwsError,
    zio.aws.iotsitewise.model.DescribeAccessPolicyResponse.ReadOnly
  ]
  def getAssetPropertyAggregates(
      request: zio.aws.iotsitewise.model.GetAssetPropertyAggregatesRequest
  ): ZStream[Any, AwsError, zio.aws.iotsitewise.model.AggregatedValue.ReadOnly]
  def getAssetPropertyAggregatesPaginated(
      request: zio.aws.iotsitewise.model.GetAssetPropertyAggregatesRequest
  ): IO[
    AwsError,
    zio.aws.iotsitewise.model.GetAssetPropertyAggregatesResponse.ReadOnly
  ]
  def batchGetAssetPropertyAggregates(
      request: zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesRequest
  ): IO[
    AwsError,
    zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesResponse.ReadOnly
  ]
  def deleteAsset(
      request: zio.aws.iotsitewise.model.DeleteAssetRequest
  ): IO[AwsError, zio.aws.iotsitewise.model.DeleteAssetResponse.ReadOnly]
  def describePortal(
      request: zio.aws.iotsitewise.model.DescribePortalRequest
  ): IO[AwsError, zio.aws.iotsitewise.model.DescribePortalResponse.ReadOnly]
  def updatePortal(
      request: zio.aws.iotsitewise.model.UpdatePortalRequest
  ): IO[AwsError, zio.aws.iotsitewise.model.UpdatePortalResponse.ReadOnly]
  def deleteDashboard(
      request: zio.aws.iotsitewise.model.DeleteDashboardRequest
  ): IO[AwsError, zio.aws.iotsitewise.model.DeleteDashboardResponse.ReadOnly]
  def batchGetAssetPropertyValue(
      request: zio.aws.iotsitewise.model.BatchGetAssetPropertyValueRequest
  ): IO[
    AwsError,
    zio.aws.iotsitewise.model.BatchGetAssetPropertyValueResponse.ReadOnly
  ]
  def describeAssetProperty(
      request: zio.aws.iotsitewise.model.DescribeAssetPropertyRequest
  ): IO[
    AwsError,
    zio.aws.iotsitewise.model.DescribeAssetPropertyResponse.ReadOnly
  ]
  def describeDashboard(
      request: zio.aws.iotsitewise.model.DescribeDashboardRequest
  ): IO[AwsError, zio.aws.iotsitewise.model.DescribeDashboardResponse.ReadOnly]
  def listTagsForResource(
      request: zio.aws.iotsitewise.model.ListTagsForResourceRequest
  ): IO[
    AwsError,
    zio.aws.iotsitewise.model.ListTagsForResourceResponse.ReadOnly
  ]
  def describeProject(
      request: zio.aws.iotsitewise.model.DescribeProjectRequest
  ): IO[AwsError, zio.aws.iotsitewise.model.DescribeProjectResponse.ReadOnly]
  def tagResource(
      request: zio.aws.iotsitewise.model.TagResourceRequest
  ): IO[AwsError, zio.aws.iotsitewise.model.TagResourceResponse.ReadOnly]
  def batchGetAssetPropertyValueHistory(
      request: zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryRequest
  ): IO[
    AwsError,
    zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryResponse.ReadOnly
  ]
  def batchDisassociateProjectAssets(
      request: zio.aws.iotsitewise.model.BatchDisassociateProjectAssetsRequest
  ): IO[
    AwsError,
    zio.aws.iotsitewise.model.BatchDisassociateProjectAssetsResponse.ReadOnly
  ]
  def batchPutAssetPropertyValue(
      request: zio.aws.iotsitewise.model.BatchPutAssetPropertyValueRequest
  ): IO[
    AwsError,
    zio.aws.iotsitewise.model.BatchPutAssetPropertyValueResponse.ReadOnly
  ]
  def updateAsset(
      request: zio.aws.iotsitewise.model.UpdateAssetRequest
  ): IO[AwsError, zio.aws.iotsitewise.model.UpdateAssetResponse.ReadOnly]
  def updateAssetProperty(
      request: zio.aws.iotsitewise.model.UpdateAssetPropertyRequest
  ): IO[AwsError, Unit]
  def listProjectAssets(
      request: zio.aws.iotsitewise.model.ListProjectAssetsRequest
  ): ZStream[Any, AwsError, ID]
  def listProjectAssetsPaginated(
      request: zio.aws.iotsitewise.model.ListProjectAssetsRequest
  ): IO[AwsError, zio.aws.iotsitewise.model.ListProjectAssetsResponse.ReadOnly]
  def deleteProject(
      request: zio.aws.iotsitewise.model.DeleteProjectRequest
  ): IO[AwsError, zio.aws.iotsitewise.model.DeleteProjectResponse.ReadOnly]
  def listAssociatedAssets(
      request: zio.aws.iotsitewise.model.ListAssociatedAssetsRequest
  ): ZStream[Any, AwsError, ReadOnly]
  def listAssociatedAssetsPaginated(
      request: zio.aws.iotsitewise.model.ListAssociatedAssetsRequest
  ): IO[
    AwsError,
    zio.aws.iotsitewise.model.ListAssociatedAssetsResponse.ReadOnly
  ]
  def disassociateTimeSeriesFromAssetProperty(
      request: zio.aws.iotsitewise.model.DisassociateTimeSeriesFromAssetPropertyRequest
  ): IO[AwsError, Unit]
  def createAssetModel(
      request: zio.aws.iotsitewise.model.CreateAssetModelRequest
  ): IO[AwsError, zio.aws.iotsitewise.model.CreateAssetModelResponse.ReadOnly]
  def describeGatewayCapabilityConfiguration(
      request: zio.aws.iotsitewise.model.DescribeGatewayCapabilityConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.iotsitewise.model.DescribeGatewayCapabilityConfigurationResponse.ReadOnly
  ]
  def updateGatewayCapabilityConfiguration(
      request: zio.aws.iotsitewise.model.UpdateGatewayCapabilityConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.iotsitewise.model.UpdateGatewayCapabilityConfigurationResponse.ReadOnly
  ]
  def describeStorageConfiguration(
      request: zio.aws.iotsitewise.model.DescribeStorageConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.iotsitewise.model.DescribeStorageConfigurationResponse.ReadOnly
  ]
  def listAssetModels(
      request: zio.aws.iotsitewise.model.ListAssetModelsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.iotsitewise.model.AssetModelSummary.ReadOnly
  ]
  def listAssetModelsPaginated(
      request: zio.aws.iotsitewise.model.ListAssetModelsRequest
  ): IO[AwsError, zio.aws.iotsitewise.model.ListAssetModelsResponse.ReadOnly]
  def listGateways(
      request: zio.aws.iotsitewise.model.ListGatewaysRequest
  ): ZStream[Any, AwsError, zio.aws.iotsitewise.model.GatewaySummary.ReadOnly]
  def listGatewaysPaginated(
      request: zio.aws.iotsitewise.model.ListGatewaysRequest
  ): IO[AwsError, zio.aws.iotsitewise.model.ListGatewaysResponse.ReadOnly]
  def listTimeSeries(
      request: zio.aws.iotsitewise.model.ListTimeSeriesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.iotsitewise.model.TimeSeriesSummary.ReadOnly
  ]
  def listTimeSeriesPaginated(
      request: zio.aws.iotsitewise.model.ListTimeSeriesRequest
  ): IO[AwsError, zio.aws.iotsitewise.model.ListTimeSeriesResponse.ReadOnly]
  def getAssetPropertyValueHistory(
      request: zio.aws.iotsitewise.model.GetAssetPropertyValueHistoryRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.iotsitewise.model.AssetPropertyValue.ReadOnly
  ]
  def getAssetPropertyValueHistoryPaginated(
      request: zio.aws.iotsitewise.model.GetAssetPropertyValueHistoryRequest
  ): IO[
    AwsError,
    zio.aws.iotsitewise.model.GetAssetPropertyValueHistoryResponse.ReadOnly
  ]
}
object IoTSiteWise {
  val live: ZLayer[AwsConfig, java.lang.Throwable, IoTSiteWise] = customized(
    identity
  )
  def customized(
      customization: IoTSiteWiseAsyncClientBuilder => IoTSiteWiseAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, IoTSiteWise] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: IoTSiteWiseAsyncClientBuilder => IoTSiteWiseAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, IoTSiteWise] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = IoTSiteWiseAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[IoTSiteWiseAsyncClient, IoTSiteWiseAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      IoTSiteWiseAsyncClient,
      IoTSiteWiseAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new IoTSiteWiseImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class IoTSiteWiseImpl[R](
      override val api: IoTSiteWiseAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends IoTSiteWise
      with AwsServiceBase[R] {
    override val serviceName: String = "IoTSiteWise"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): IoTSiteWiseImpl[R1] = new IoTSiteWiseImpl(api, newAspect, r)
    def associateAssets(
        request: zio.aws.iotsitewise.model.AssociateAssetsRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[AssociateAssetsRequest, AssociateAssetsResponse](
        "associateAssets",
        api.associateAssets
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def updateGateway(
        request: zio.aws.iotsitewise.model.UpdateGatewayRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[UpdateGatewayRequest, UpdateGatewayResponse](
        "updateGateway",
        api.updateGateway
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def createPortal(
        request: zio.aws.iotsitewise.model.CreatePortalRequest
    ): IO[AwsError, zio.aws.iotsitewise.model.CreatePortalResponse.ReadOnly] =
      asyncRequestResponse[CreatePortalRequest, CreatePortalResponse](
        "createPortal",
        api.createPortal
      )(request.buildAwsValue())
        .map(zio.aws.iotsitewise.model.CreatePortalResponse.wrap)
        .provideEnvironment(r)
    def listPortals(
        request: zio.aws.iotsitewise.model.ListPortalsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.PortalSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListPortalsRequest,
      PortalSummary,
      ListPortalsPublisher
    ]("listPortals", api.listPortalsPaginator, _.portalSummaries())(
      request.buildAwsValue()
    ).map(item => zio.aws.iotsitewise.model.PortalSummary.wrap(item))
      .provideEnvironment(r)
    def listPortalsPaginated(
        request: zio.aws.iotsitewise.model.ListPortalsRequest
    ): IO[AwsError, zio.aws.iotsitewise.model.ListPortalsResponse.ReadOnly] =
      asyncRequestResponse[ListPortalsRequest, ListPortalsResponse](
        "listPortals",
        api.listPortals
      )(request.buildAwsValue())
        .map(zio.aws.iotsitewise.model.ListPortalsResponse.wrap)
        .provideEnvironment(r)
    def deletePortal(
        request: zio.aws.iotsitewise.model.DeletePortalRequest
    ): IO[AwsError, zio.aws.iotsitewise.model.DeletePortalResponse.ReadOnly] =
      asyncRequestResponse[DeletePortalRequest, DeletePortalResponse](
        "deletePortal",
        api.deletePortal
      )(request.buildAwsValue())
        .map(zio.aws.iotsitewise.model.DeletePortalResponse.wrap)
        .provideEnvironment(r)
    def createGateway(
        request: zio.aws.iotsitewise.model.CreateGatewayRequest
    ): IO[AwsError, zio.aws.iotsitewise.model.CreateGatewayResponse.ReadOnly] =
      asyncRequestResponse[CreateGatewayRequest, CreateGatewayResponse](
        "createGateway",
        api.createGateway
      )(request.buildAwsValue())
        .map(zio.aws.iotsitewise.model.CreateGatewayResponse.wrap)
        .provideEnvironment(r)
    def updateAccessPolicy(
        request: zio.aws.iotsitewise.model.UpdateAccessPolicyRequest
    ): IO[
      AwsError,
      zio.aws.iotsitewise.model.UpdateAccessPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateAccessPolicyRequest,
      UpdateAccessPolicyResponse
    ]("updateAccessPolicy", api.updateAccessPolicy)(request.buildAwsValue())
      .map(zio.aws.iotsitewise.model.UpdateAccessPolicyResponse.wrap)
      .provideEnvironment(r)
    def deleteAssetModel(
        request: zio.aws.iotsitewise.model.DeleteAssetModelRequest
    ): IO[
      AwsError,
      zio.aws.iotsitewise.model.DeleteAssetModelResponse.ReadOnly
    ] = asyncRequestResponse[DeleteAssetModelRequest, DeleteAssetModelResponse](
      "deleteAssetModel",
      api.deleteAssetModel
    )(request.buildAwsValue())
      .map(zio.aws.iotsitewise.model.DeleteAssetModelResponse.wrap)
      .provideEnvironment(r)
    def disassociateAssets(
        request: zio.aws.iotsitewise.model.DisassociateAssetsRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DisassociateAssetsRequest,
      DisassociateAssetsResponse
    ]("disassociateAssets", api.disassociateAssets)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteGateway(
        request: zio.aws.iotsitewise.model.DeleteGatewayRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteGatewayRequest, DeleteGatewayResponse](
        "deleteGateway",
        api.deleteGateway
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def updateProject(
        request: zio.aws.iotsitewise.model.UpdateProjectRequest
    ): IO[AwsError, zio.aws.iotsitewise.model.UpdateProjectResponse.ReadOnly] =
      asyncRequestResponse[UpdateProjectRequest, UpdateProjectResponse](
        "updateProject",
        api.updateProject
      )(request.buildAwsValue())
        .map(zio.aws.iotsitewise.model.UpdateProjectResponse.wrap)
        .provideEnvironment(r)
    def associateTimeSeriesToAssetProperty(
        request: zio.aws.iotsitewise.model.AssociateTimeSeriesToAssetPropertyRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      AssociateTimeSeriesToAssetPropertyRequest,
      AssociateTimeSeriesToAssetPropertyResponse
    ](
      "associateTimeSeriesToAssetProperty",
      api.associateTimeSeriesToAssetProperty
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def batchAssociateProjectAssets(
        request: zio.aws.iotsitewise.model.BatchAssociateProjectAssetsRequest
    ): IO[
      AwsError,
      zio.aws.iotsitewise.model.BatchAssociateProjectAssetsResponse.ReadOnly
    ] = asyncRequestResponse[
      BatchAssociateProjectAssetsRequest,
      BatchAssociateProjectAssetsResponse
    ]("batchAssociateProjectAssets", api.batchAssociateProjectAssets)(
      request.buildAwsValue()
    ).map(zio.aws.iotsitewise.model.BatchAssociateProjectAssetsResponse.wrap)
      .provideEnvironment(r)
    def createAccessPolicy(
        request: zio.aws.iotsitewise.model.CreateAccessPolicyRequest
    ): IO[
      AwsError,
      zio.aws.iotsitewise.model.CreateAccessPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateAccessPolicyRequest,
      CreateAccessPolicyResponse
    ]("createAccessPolicy", api.createAccessPolicy)(request.buildAwsValue())
      .map(zio.aws.iotsitewise.model.CreateAccessPolicyResponse.wrap)
      .provideEnvironment(r)
    def describeLoggingOptions(
        request: zio.aws.iotsitewise.model.DescribeLoggingOptionsRequest
    ): IO[
      AwsError,
      zio.aws.iotsitewise.model.DescribeLoggingOptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeLoggingOptionsRequest,
      DescribeLoggingOptionsResponse
    ]("describeLoggingOptions", api.describeLoggingOptions)(
      request.buildAwsValue()
    ).map(zio.aws.iotsitewise.model.DescribeLoggingOptionsResponse.wrap)
      .provideEnvironment(r)
    def describeAsset(
        request: zio.aws.iotsitewise.model.DescribeAssetRequest
    ): IO[AwsError, zio.aws.iotsitewise.model.DescribeAssetResponse.ReadOnly] =
      asyncRequestResponse[DescribeAssetRequest, DescribeAssetResponse](
        "describeAsset",
        api.describeAsset
      )(request.buildAwsValue())
        .map(zio.aws.iotsitewise.model.DescribeAssetResponse.wrap)
        .provideEnvironment(r)
    def deleteTimeSeries(
        request: zio.aws.iotsitewise.model.DeleteTimeSeriesRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteTimeSeriesRequest, DeleteTimeSeriesResponse](
        "deleteTimeSeries",
        api.deleteTimeSeries
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def putStorageConfiguration(
        request: zio.aws.iotsitewise.model.PutStorageConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.iotsitewise.model.PutStorageConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      PutStorageConfigurationRequest,
      PutStorageConfigurationResponse
    ]("putStorageConfiguration", api.putStorageConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.iotsitewise.model.PutStorageConfigurationResponse.wrap)
      .provideEnvironment(r)
    def describeAssetModel(
        request: zio.aws.iotsitewise.model.DescribeAssetModelRequest
    ): IO[
      AwsError,
      zio.aws.iotsitewise.model.DescribeAssetModelResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeAssetModelRequest,
      DescribeAssetModelResponse
    ]("describeAssetModel", api.describeAssetModel)(request.buildAwsValue())
      .map(zio.aws.iotsitewise.model.DescribeAssetModelResponse.wrap)
      .provideEnvironment(r)
    def listAssets(
        request: zio.aws.iotsitewise.model.ListAssetsRequest
    ): ZStream[Any, AwsError, zio.aws.iotsitewise.model.AssetSummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListAssetsRequest,
        AssetSummary,
        ListAssetsPublisher
      ]("listAssets", api.listAssetsPaginator, _.assetSummaries())(
        request.buildAwsValue()
      ).map(item => zio.aws.iotsitewise.model.AssetSummary.wrap(item))
        .provideEnvironment(r)
    def listAssetsPaginated(
        request: zio.aws.iotsitewise.model.ListAssetsRequest
    ): IO[AwsError, zio.aws.iotsitewise.model.ListAssetsResponse.ReadOnly] =
      asyncRequestResponse[ListAssetsRequest, ListAssetsResponse](
        "listAssets",
        api.listAssets
      )(request.buildAwsValue())
        .map(zio.aws.iotsitewise.model.ListAssetsResponse.wrap)
        .provideEnvironment(r)
    def getInterpolatedAssetPropertyValues(
        request: zio.aws.iotsitewise.model.GetInterpolatedAssetPropertyValuesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.InterpolatedAssetPropertyValue.ReadOnly
    ] = asyncJavaPaginatedRequest[
      GetInterpolatedAssetPropertyValuesRequest,
      InterpolatedAssetPropertyValue,
      GetInterpolatedAssetPropertyValuesPublisher
    ](
      "getInterpolatedAssetPropertyValues",
      api.getInterpolatedAssetPropertyValuesPaginator,
      _.interpolatedAssetPropertyValues()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.iotsitewise.model.InterpolatedAssetPropertyValue.wrap(item)
      )
      .provideEnvironment(r)
    def getInterpolatedAssetPropertyValuesPaginated(
        request: zio.aws.iotsitewise.model.GetInterpolatedAssetPropertyValuesRequest
    ): IO[
      AwsError,
      zio.aws.iotsitewise.model.GetInterpolatedAssetPropertyValuesResponse.ReadOnly
    ] = asyncRequestResponse[
      GetInterpolatedAssetPropertyValuesRequest,
      GetInterpolatedAssetPropertyValuesResponse
    ](
      "getInterpolatedAssetPropertyValues",
      api.getInterpolatedAssetPropertyValues
    )(request.buildAwsValue())
      .map(
        zio.aws.iotsitewise.model.GetInterpolatedAssetPropertyValuesResponse.wrap
      )
      .provideEnvironment(r)
    def updateAssetModel(
        request: zio.aws.iotsitewise.model.UpdateAssetModelRequest
    ): IO[
      AwsError,
      zio.aws.iotsitewise.model.UpdateAssetModelResponse.ReadOnly
    ] = asyncRequestResponse[UpdateAssetModelRequest, UpdateAssetModelResponse](
      "updateAssetModel",
      api.updateAssetModel
    )(request.buildAwsValue())
      .map(zio.aws.iotsitewise.model.UpdateAssetModelResponse.wrap)
      .provideEnvironment(r)
    def listProjects(
        request: zio.aws.iotsitewise.model.ListProjectsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.ProjectSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListProjectsRequest,
      ProjectSummary,
      ListProjectsPublisher
    ]("listProjects", api.listProjectsPaginator, _.projectSummaries())(
      request.buildAwsValue()
    ).map(item => zio.aws.iotsitewise.model.ProjectSummary.wrap(item))
      .provideEnvironment(r)
    def listProjectsPaginated(
        request: zio.aws.iotsitewise.model.ListProjectsRequest
    ): IO[AwsError, zio.aws.iotsitewise.model.ListProjectsResponse.ReadOnly] =
      asyncRequestResponse[ListProjectsRequest, ListProjectsResponse](
        "listProjects",
        api.listProjects
      )(request.buildAwsValue())
        .map(zio.aws.iotsitewise.model.ListProjectsResponse.wrap)
        .provideEnvironment(r)
    def putLoggingOptions(
        request: zio.aws.iotsitewise.model.PutLoggingOptionsRequest
    ): IO[
      AwsError,
      zio.aws.iotsitewise.model.PutLoggingOptionsResponse.ReadOnly
    ] =
      asyncRequestResponse[PutLoggingOptionsRequest, PutLoggingOptionsResponse](
        "putLoggingOptions",
        api.putLoggingOptions
      )(request.buildAwsValue())
        .map(zio.aws.iotsitewise.model.PutLoggingOptionsResponse.wrap)
        .provideEnvironment(r)
    def deleteAccessPolicy(
        request: zio.aws.iotsitewise.model.DeleteAccessPolicyRequest
    ): IO[
      AwsError,
      zio.aws.iotsitewise.model.DeleteAccessPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteAccessPolicyRequest,
      DeleteAccessPolicyResponse
    ]("deleteAccessPolicy", api.deleteAccessPolicy)(request.buildAwsValue())
      .map(zio.aws.iotsitewise.model.DeleteAccessPolicyResponse.wrap)
      .provideEnvironment(r)
    def listAssetRelationships(
        request: zio.aws.iotsitewise.model.ListAssetRelationshipsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.AssetRelationshipSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListAssetRelationshipsRequest,
      AssetRelationshipSummary,
      ListAssetRelationshipsPublisher
    ](
      "listAssetRelationships",
      api.listAssetRelationshipsPaginator,
      _.assetRelationshipSummaries()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.iotsitewise.model.AssetRelationshipSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listAssetRelationshipsPaginated(
        request: zio.aws.iotsitewise.model.ListAssetRelationshipsRequest
    ): IO[
      AwsError,
      zio.aws.iotsitewise.model.ListAssetRelationshipsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListAssetRelationshipsRequest,
      ListAssetRelationshipsResponse
    ]("listAssetRelationships", api.listAssetRelationships)(
      request.buildAwsValue()
    ).map(zio.aws.iotsitewise.model.ListAssetRelationshipsResponse.wrap)
      .provideEnvironment(r)
    def listDashboards(
        request: zio.aws.iotsitewise.model.ListDashboardsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.DashboardSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListDashboardsRequest,
      DashboardSummary,
      ListDashboardsPublisher
    ]("listDashboards", api.listDashboardsPaginator, _.dashboardSummaries())(
      request.buildAwsValue()
    ).map(item => zio.aws.iotsitewise.model.DashboardSummary.wrap(item))
      .provideEnvironment(r)
    def listDashboardsPaginated(
        request: zio.aws.iotsitewise.model.ListDashboardsRequest
    ): IO[AwsError, zio.aws.iotsitewise.model.ListDashboardsResponse.ReadOnly] =
      asyncRequestResponse[ListDashboardsRequest, ListDashboardsResponse](
        "listDashboards",
        api.listDashboards
      )(request.buildAwsValue())
        .map(zio.aws.iotsitewise.model.ListDashboardsResponse.wrap)
        .provideEnvironment(r)
    def updateDashboard(
        request: zio.aws.iotsitewise.model.UpdateDashboardRequest
    ): IO[
      AwsError,
      zio.aws.iotsitewise.model.UpdateDashboardResponse.ReadOnly
    ] = asyncRequestResponse[UpdateDashboardRequest, UpdateDashboardResponse](
      "updateDashboard",
      api.updateDashboard
    )(request.buildAwsValue())
      .map(zio.aws.iotsitewise.model.UpdateDashboardResponse.wrap)
      .provideEnvironment(r)
    def listAccessPolicies(
        request: zio.aws.iotsitewise.model.ListAccessPoliciesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.AccessPolicySummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListAccessPoliciesRequest,
      AccessPolicySummary,
      ListAccessPoliciesPublisher
    ](
      "listAccessPolicies",
      api.listAccessPoliciesPaginator,
      _.accessPolicySummaries()
    )(request.buildAwsValue())
      .map(item => zio.aws.iotsitewise.model.AccessPolicySummary.wrap(item))
      .provideEnvironment(r)
    def listAccessPoliciesPaginated(
        request: zio.aws.iotsitewise.model.ListAccessPoliciesRequest
    ): IO[
      AwsError,
      zio.aws.iotsitewise.model.ListAccessPoliciesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListAccessPoliciesRequest,
      ListAccessPoliciesResponse
    ]("listAccessPolicies", api.listAccessPolicies)(request.buildAwsValue())
      .map(zio.aws.iotsitewise.model.ListAccessPoliciesResponse.wrap)
      .provideEnvironment(r)
    def createDashboard(
        request: zio.aws.iotsitewise.model.CreateDashboardRequest
    ): IO[
      AwsError,
      zio.aws.iotsitewise.model.CreateDashboardResponse.ReadOnly
    ] = asyncRequestResponse[CreateDashboardRequest, CreateDashboardResponse](
      "createDashboard",
      api.createDashboard
    )(request.buildAwsValue())
      .map(zio.aws.iotsitewise.model.CreateDashboardResponse.wrap)
      .provideEnvironment(r)
    def createAsset(
        request: zio.aws.iotsitewise.model.CreateAssetRequest
    ): IO[AwsError, zio.aws.iotsitewise.model.CreateAssetResponse.ReadOnly] =
      asyncRequestResponse[CreateAssetRequest, CreateAssetResponse](
        "createAsset",
        api.createAsset
      )(request.buildAwsValue())
        .map(zio.aws.iotsitewise.model.CreateAssetResponse.wrap)
        .provideEnvironment(r)
    def describeTimeSeries(
        request: zio.aws.iotsitewise.model.DescribeTimeSeriesRequest
    ): IO[
      AwsError,
      zio.aws.iotsitewise.model.DescribeTimeSeriesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeTimeSeriesRequest,
      DescribeTimeSeriesResponse
    ]("describeTimeSeries", api.describeTimeSeries)(request.buildAwsValue())
      .map(zio.aws.iotsitewise.model.DescribeTimeSeriesResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: zio.aws.iotsitewise.model.UntagResourceRequest
    ): IO[AwsError, zio.aws.iotsitewise.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue())
        .map(zio.aws.iotsitewise.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def createProject(
        request: zio.aws.iotsitewise.model.CreateProjectRequest
    ): IO[AwsError, zio.aws.iotsitewise.model.CreateProjectResponse.ReadOnly] =
      asyncRequestResponse[CreateProjectRequest, CreateProjectResponse](
        "createProject",
        api.createProject
      )(request.buildAwsValue())
        .map(zio.aws.iotsitewise.model.CreateProjectResponse.wrap)
        .provideEnvironment(r)
    def describeDefaultEncryptionConfiguration(
        request: zio.aws.iotsitewise.model.DescribeDefaultEncryptionConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.iotsitewise.model.DescribeDefaultEncryptionConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeDefaultEncryptionConfigurationRequest,
      DescribeDefaultEncryptionConfigurationResponse
    ](
      "describeDefaultEncryptionConfiguration",
      api.describeDefaultEncryptionConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.iotsitewise.model.DescribeDefaultEncryptionConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def describeGateway(
        request: zio.aws.iotsitewise.model.DescribeGatewayRequest
    ): IO[
      AwsError,
      zio.aws.iotsitewise.model.DescribeGatewayResponse.ReadOnly
    ] = asyncRequestResponse[DescribeGatewayRequest, DescribeGatewayResponse](
      "describeGateway",
      api.describeGateway
    )(request.buildAwsValue())
      .map(zio.aws.iotsitewise.model.DescribeGatewayResponse.wrap)
      .provideEnvironment(r)
    def getAssetPropertyValue(
        request: zio.aws.iotsitewise.model.GetAssetPropertyValueRequest
    ): IO[
      AwsError,
      zio.aws.iotsitewise.model.GetAssetPropertyValueResponse.ReadOnly
    ] = asyncRequestResponse[
      GetAssetPropertyValueRequest,
      GetAssetPropertyValueResponse
    ]("getAssetPropertyValue", api.getAssetPropertyValue)(
      request.buildAwsValue()
    ).map(zio.aws.iotsitewise.model.GetAssetPropertyValueResponse.wrap)
      .provideEnvironment(r)
    def putDefaultEncryptionConfiguration(
        request: zio.aws.iotsitewise.model.PutDefaultEncryptionConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.iotsitewise.model.PutDefaultEncryptionConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      PutDefaultEncryptionConfigurationRequest,
      PutDefaultEncryptionConfigurationResponse
    ](
      "putDefaultEncryptionConfiguration",
      api.putDefaultEncryptionConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.iotsitewise.model.PutDefaultEncryptionConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def describeAccessPolicy(
        request: zio.aws.iotsitewise.model.DescribeAccessPolicyRequest
    ): IO[
      AwsError,
      zio.aws.iotsitewise.model.DescribeAccessPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeAccessPolicyRequest,
      DescribeAccessPolicyResponse
    ]("describeAccessPolicy", api.describeAccessPolicy)(request.buildAwsValue())
      .map(zio.aws.iotsitewise.model.DescribeAccessPolicyResponse.wrap)
      .provideEnvironment(r)
    def getAssetPropertyAggregates(
        request: zio.aws.iotsitewise.model.GetAssetPropertyAggregatesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.AggregatedValue.ReadOnly
    ] = asyncJavaPaginatedRequest[
      GetAssetPropertyAggregatesRequest,
      AggregatedValue,
      GetAssetPropertyAggregatesPublisher
    ](
      "getAssetPropertyAggregates",
      api.getAssetPropertyAggregatesPaginator,
      _.aggregatedValues()
    )(request.buildAwsValue())
      .map(item => zio.aws.iotsitewise.model.AggregatedValue.wrap(item))
      .provideEnvironment(r)
    def getAssetPropertyAggregatesPaginated(
        request: zio.aws.iotsitewise.model.GetAssetPropertyAggregatesRequest
    ): IO[
      AwsError,
      zio.aws.iotsitewise.model.GetAssetPropertyAggregatesResponse.ReadOnly
    ] = asyncRequestResponse[
      GetAssetPropertyAggregatesRequest,
      GetAssetPropertyAggregatesResponse
    ]("getAssetPropertyAggregates", api.getAssetPropertyAggregates)(
      request.buildAwsValue()
    ).map(zio.aws.iotsitewise.model.GetAssetPropertyAggregatesResponse.wrap)
      .provideEnvironment(r)
    def batchGetAssetPropertyAggregates(
        request: zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesRequest
    ): IO[
      AwsError,
      zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesResponse.ReadOnly
    ] = asyncRequestResponse[
      BatchGetAssetPropertyAggregatesRequest,
      BatchGetAssetPropertyAggregatesResponse
    ]("batchGetAssetPropertyAggregates", api.batchGetAssetPropertyAggregates)(
      request.buildAwsValue()
    ).map(
      zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesResponse.wrap
    ).provideEnvironment(r)
    def deleteAsset(
        request: zio.aws.iotsitewise.model.DeleteAssetRequest
    ): IO[AwsError, zio.aws.iotsitewise.model.DeleteAssetResponse.ReadOnly] =
      asyncRequestResponse[DeleteAssetRequest, DeleteAssetResponse](
        "deleteAsset",
        api.deleteAsset
      )(request.buildAwsValue())
        .map(zio.aws.iotsitewise.model.DeleteAssetResponse.wrap)
        .provideEnvironment(r)
    def describePortal(
        request: zio.aws.iotsitewise.model.DescribePortalRequest
    ): IO[AwsError, zio.aws.iotsitewise.model.DescribePortalResponse.ReadOnly] =
      asyncRequestResponse[DescribePortalRequest, DescribePortalResponse](
        "describePortal",
        api.describePortal
      )(request.buildAwsValue())
        .map(zio.aws.iotsitewise.model.DescribePortalResponse.wrap)
        .provideEnvironment(r)
    def updatePortal(
        request: zio.aws.iotsitewise.model.UpdatePortalRequest
    ): IO[AwsError, zio.aws.iotsitewise.model.UpdatePortalResponse.ReadOnly] =
      asyncRequestResponse[UpdatePortalRequest, UpdatePortalResponse](
        "updatePortal",
        api.updatePortal
      )(request.buildAwsValue())
        .map(zio.aws.iotsitewise.model.UpdatePortalResponse.wrap)
        .provideEnvironment(r)
    def deleteDashboard(
        request: zio.aws.iotsitewise.model.DeleteDashboardRequest
    ): IO[
      AwsError,
      zio.aws.iotsitewise.model.DeleteDashboardResponse.ReadOnly
    ] = asyncRequestResponse[DeleteDashboardRequest, DeleteDashboardResponse](
      "deleteDashboard",
      api.deleteDashboard
    )(request.buildAwsValue())
      .map(zio.aws.iotsitewise.model.DeleteDashboardResponse.wrap)
      .provideEnvironment(r)
    def batchGetAssetPropertyValue(
        request: zio.aws.iotsitewise.model.BatchGetAssetPropertyValueRequest
    ): IO[
      AwsError,
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueResponse.ReadOnly
    ] = asyncRequestResponse[
      BatchGetAssetPropertyValueRequest,
      BatchGetAssetPropertyValueResponse
    ]("batchGetAssetPropertyValue", api.batchGetAssetPropertyValue)(
      request.buildAwsValue()
    ).map(zio.aws.iotsitewise.model.BatchGetAssetPropertyValueResponse.wrap)
      .provideEnvironment(r)
    def describeAssetProperty(
        request: zio.aws.iotsitewise.model.DescribeAssetPropertyRequest
    ): IO[
      AwsError,
      zio.aws.iotsitewise.model.DescribeAssetPropertyResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeAssetPropertyRequest,
      DescribeAssetPropertyResponse
    ]("describeAssetProperty", api.describeAssetProperty)(
      request.buildAwsValue()
    ).map(zio.aws.iotsitewise.model.DescribeAssetPropertyResponse.wrap)
      .provideEnvironment(r)
    def describeDashboard(
        request: zio.aws.iotsitewise.model.DescribeDashboardRequest
    ): IO[
      AwsError,
      zio.aws.iotsitewise.model.DescribeDashboardResponse.ReadOnly
    ] =
      asyncRequestResponse[DescribeDashboardRequest, DescribeDashboardResponse](
        "describeDashboard",
        api.describeDashboard
      )(request.buildAwsValue())
        .map(zio.aws.iotsitewise.model.DescribeDashboardResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.iotsitewise.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.iotsitewise.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.iotsitewise.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def describeProject(
        request: zio.aws.iotsitewise.model.DescribeProjectRequest
    ): IO[
      AwsError,
      zio.aws.iotsitewise.model.DescribeProjectResponse.ReadOnly
    ] = asyncRequestResponse[DescribeProjectRequest, DescribeProjectResponse](
      "describeProject",
      api.describeProject
    )(request.buildAwsValue())
      .map(zio.aws.iotsitewise.model.DescribeProjectResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: zio.aws.iotsitewise.model.TagResourceRequest
    ): IO[AwsError, zio.aws.iotsitewise.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.iotsitewise.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def batchGetAssetPropertyValueHistory(
        request: zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryRequest
    ): IO[
      AwsError,
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryResponse.ReadOnly
    ] = asyncRequestResponse[
      BatchGetAssetPropertyValueHistoryRequest,
      BatchGetAssetPropertyValueHistoryResponse
    ](
      "batchGetAssetPropertyValueHistory",
      api.batchGetAssetPropertyValueHistory
    )(request.buildAwsValue())
      .map(
        zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryResponse.wrap
      )
      .provideEnvironment(r)
    def batchDisassociateProjectAssets(
        request: zio.aws.iotsitewise.model.BatchDisassociateProjectAssetsRequest
    ): IO[
      AwsError,
      zio.aws.iotsitewise.model.BatchDisassociateProjectAssetsResponse.ReadOnly
    ] = asyncRequestResponse[
      BatchDisassociateProjectAssetsRequest,
      BatchDisassociateProjectAssetsResponse
    ]("batchDisassociateProjectAssets", api.batchDisassociateProjectAssets)(
      request.buildAwsValue()
    ).map(zio.aws.iotsitewise.model.BatchDisassociateProjectAssetsResponse.wrap)
      .provideEnvironment(r)
    def batchPutAssetPropertyValue(
        request: zio.aws.iotsitewise.model.BatchPutAssetPropertyValueRequest
    ): IO[
      AwsError,
      zio.aws.iotsitewise.model.BatchPutAssetPropertyValueResponse.ReadOnly
    ] = asyncRequestResponse[
      BatchPutAssetPropertyValueRequest,
      BatchPutAssetPropertyValueResponse
    ]("batchPutAssetPropertyValue", api.batchPutAssetPropertyValue)(
      request.buildAwsValue()
    ).map(zio.aws.iotsitewise.model.BatchPutAssetPropertyValueResponse.wrap)
      .provideEnvironment(r)
    def updateAsset(
        request: zio.aws.iotsitewise.model.UpdateAssetRequest
    ): IO[AwsError, zio.aws.iotsitewise.model.UpdateAssetResponse.ReadOnly] =
      asyncRequestResponse[UpdateAssetRequest, UpdateAssetResponse](
        "updateAsset",
        api.updateAsset
      )(request.buildAwsValue())
        .map(zio.aws.iotsitewise.model.UpdateAssetResponse.wrap)
        .provideEnvironment(r)
    def updateAssetProperty(
        request: zio.aws.iotsitewise.model.UpdateAssetPropertyRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      UpdateAssetPropertyRequest,
      UpdateAssetPropertyResponse
    ]("updateAssetProperty", api.updateAssetProperty)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listProjectAssets(
        request: zio.aws.iotsitewise.model.ListProjectAssetsRequest
    ): ZStream[Any, AwsError, ID] = asyncJavaPaginatedRequest[
      ListProjectAssetsRequest,
      java.lang.String,
      ListProjectAssetsPublisher
    ]("listProjectAssets", api.listProjectAssetsPaginator, _.assetIds())(
      request.buildAwsValue()
    ).map(item => zio.aws.iotsitewise.model.primitives.ID(item))
      .provideEnvironment(r)
    def listProjectAssetsPaginated(
        request: zio.aws.iotsitewise.model.ListProjectAssetsRequest
    ): IO[
      AwsError,
      zio.aws.iotsitewise.model.ListProjectAssetsResponse.ReadOnly
    ] =
      asyncRequestResponse[ListProjectAssetsRequest, ListProjectAssetsResponse](
        "listProjectAssets",
        api.listProjectAssets
      )(request.buildAwsValue())
        .map(zio.aws.iotsitewise.model.ListProjectAssetsResponse.wrap)
        .provideEnvironment(r)
    def deleteProject(
        request: zio.aws.iotsitewise.model.DeleteProjectRequest
    ): IO[AwsError, zio.aws.iotsitewise.model.DeleteProjectResponse.ReadOnly] =
      asyncRequestResponse[DeleteProjectRequest, DeleteProjectResponse](
        "deleteProject",
        api.deleteProject
      )(request.buildAwsValue())
        .map(zio.aws.iotsitewise.model.DeleteProjectResponse.wrap)
        .provideEnvironment(r)
    def listAssociatedAssets(
        request: zio.aws.iotsitewise.model.ListAssociatedAssetsRequest
    ): ZStream[Any, AwsError, ReadOnly] = asyncJavaPaginatedRequest[
      ListAssociatedAssetsRequest,
      AssociatedAssetsSummary,
      ListAssociatedAssetsPublisher
    ](
      "listAssociatedAssets",
      api.listAssociatedAssetsPaginator,
      _.assetSummaries()
    )(request.buildAwsValue())
      .map(item => zio.aws.iotsitewise.model.AssociatedAssetsSummary.wrap(item))
      .provideEnvironment(r)
    def listAssociatedAssetsPaginated(
        request: zio.aws.iotsitewise.model.ListAssociatedAssetsRequest
    ): IO[
      AwsError,
      zio.aws.iotsitewise.model.ListAssociatedAssetsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListAssociatedAssetsRequest,
      ListAssociatedAssetsResponse
    ]("listAssociatedAssets", api.listAssociatedAssets)(request.buildAwsValue())
      .map(zio.aws.iotsitewise.model.ListAssociatedAssetsResponse.wrap)
      .provideEnvironment(r)
    def disassociateTimeSeriesFromAssetProperty(
        request: zio.aws.iotsitewise.model.DisassociateTimeSeriesFromAssetPropertyRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DisassociateTimeSeriesFromAssetPropertyRequest,
      DisassociateTimeSeriesFromAssetPropertyResponse
    ](
      "disassociateTimeSeriesFromAssetProperty",
      api.disassociateTimeSeriesFromAssetProperty
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def createAssetModel(
        request: zio.aws.iotsitewise.model.CreateAssetModelRequest
    ): IO[
      AwsError,
      zio.aws.iotsitewise.model.CreateAssetModelResponse.ReadOnly
    ] = asyncRequestResponse[CreateAssetModelRequest, CreateAssetModelResponse](
      "createAssetModel",
      api.createAssetModel
    )(request.buildAwsValue())
      .map(zio.aws.iotsitewise.model.CreateAssetModelResponse.wrap)
      .provideEnvironment(r)
    def describeGatewayCapabilityConfiguration(
        request: zio.aws.iotsitewise.model.DescribeGatewayCapabilityConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.iotsitewise.model.DescribeGatewayCapabilityConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeGatewayCapabilityConfigurationRequest,
      DescribeGatewayCapabilityConfigurationResponse
    ](
      "describeGatewayCapabilityConfiguration",
      api.describeGatewayCapabilityConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.iotsitewise.model.DescribeGatewayCapabilityConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def updateGatewayCapabilityConfiguration(
        request: zio.aws.iotsitewise.model.UpdateGatewayCapabilityConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.iotsitewise.model.UpdateGatewayCapabilityConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateGatewayCapabilityConfigurationRequest,
      UpdateGatewayCapabilityConfigurationResponse
    ](
      "updateGatewayCapabilityConfiguration",
      api.updateGatewayCapabilityConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.iotsitewise.model.UpdateGatewayCapabilityConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def describeStorageConfiguration(
        request: zio.aws.iotsitewise.model.DescribeStorageConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.iotsitewise.model.DescribeStorageConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeStorageConfigurationRequest,
      DescribeStorageConfigurationResponse
    ]("describeStorageConfiguration", api.describeStorageConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.iotsitewise.model.DescribeStorageConfigurationResponse.wrap)
      .provideEnvironment(r)
    def listAssetModels(
        request: zio.aws.iotsitewise.model.ListAssetModelsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.AssetModelSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListAssetModelsRequest,
      AssetModelSummary,
      ListAssetModelsPublisher
    ]("listAssetModels", api.listAssetModelsPaginator, _.assetModelSummaries())(
      request.buildAwsValue()
    ).map(item => zio.aws.iotsitewise.model.AssetModelSummary.wrap(item))
      .provideEnvironment(r)
    def listAssetModelsPaginated(
        request: zio.aws.iotsitewise.model.ListAssetModelsRequest
    ): IO[
      AwsError,
      zio.aws.iotsitewise.model.ListAssetModelsResponse.ReadOnly
    ] = asyncRequestResponse[ListAssetModelsRequest, ListAssetModelsResponse](
      "listAssetModels",
      api.listAssetModels
    )(request.buildAwsValue())
      .map(zio.aws.iotsitewise.model.ListAssetModelsResponse.wrap)
      .provideEnvironment(r)
    def listGateways(
        request: zio.aws.iotsitewise.model.ListGatewaysRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.GatewaySummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListGatewaysRequest,
      GatewaySummary,
      ListGatewaysPublisher
    ]("listGateways", api.listGatewaysPaginator, _.gatewaySummaries())(
      request.buildAwsValue()
    ).map(item => zio.aws.iotsitewise.model.GatewaySummary.wrap(item))
      .provideEnvironment(r)
    def listGatewaysPaginated(
        request: zio.aws.iotsitewise.model.ListGatewaysRequest
    ): IO[AwsError, zio.aws.iotsitewise.model.ListGatewaysResponse.ReadOnly] =
      asyncRequestResponse[ListGatewaysRequest, ListGatewaysResponse](
        "listGateways",
        api.listGateways
      )(request.buildAwsValue())
        .map(zio.aws.iotsitewise.model.ListGatewaysResponse.wrap)
        .provideEnvironment(r)
    def listTimeSeries(
        request: zio.aws.iotsitewise.model.ListTimeSeriesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.TimeSeriesSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListTimeSeriesRequest,
      TimeSeriesSummary,
      ListTimeSeriesPublisher
    ]("listTimeSeries", api.listTimeSeriesPaginator, _.timeSeriesSummaries())(
      request.buildAwsValue()
    ).map(item => zio.aws.iotsitewise.model.TimeSeriesSummary.wrap(item))
      .provideEnvironment(r)
    def listTimeSeriesPaginated(
        request: zio.aws.iotsitewise.model.ListTimeSeriesRequest
    ): IO[AwsError, zio.aws.iotsitewise.model.ListTimeSeriesResponse.ReadOnly] =
      asyncRequestResponse[ListTimeSeriesRequest, ListTimeSeriesResponse](
        "listTimeSeries",
        api.listTimeSeries
      )(request.buildAwsValue())
        .map(zio.aws.iotsitewise.model.ListTimeSeriesResponse.wrap)
        .provideEnvironment(r)
    def getAssetPropertyValueHistory(
        request: zio.aws.iotsitewise.model.GetAssetPropertyValueHistoryRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.AssetPropertyValue.ReadOnly
    ] = asyncJavaPaginatedRequest[
      GetAssetPropertyValueHistoryRequest,
      AssetPropertyValue,
      GetAssetPropertyValueHistoryPublisher
    ](
      "getAssetPropertyValueHistory",
      api.getAssetPropertyValueHistoryPaginator,
      _.assetPropertyValueHistory()
    )(request.buildAwsValue())
      .map(item => zio.aws.iotsitewise.model.AssetPropertyValue.wrap(item))
      .provideEnvironment(r)
    def getAssetPropertyValueHistoryPaginated(
        request: zio.aws.iotsitewise.model.GetAssetPropertyValueHistoryRequest
    ): IO[
      AwsError,
      zio.aws.iotsitewise.model.GetAssetPropertyValueHistoryResponse.ReadOnly
    ] = asyncRequestResponse[
      GetAssetPropertyValueHistoryRequest,
      GetAssetPropertyValueHistoryResponse
    ]("getAssetPropertyValueHistory", api.getAssetPropertyValueHistory)(
      request.buildAwsValue()
    ).map(zio.aws.iotsitewise.model.GetAssetPropertyValueHistoryResponse.wrap)
      .provideEnvironment(r)
  }
  def associateAssets(
      request: zio.aws.iotsitewise.model.AssociateAssetsRequest
  ): ZIO[zio.aws.iotsitewise.IoTSiteWise, AwsError, Unit] =
    ZIO.serviceWithZIO(_.associateAssets(request))
  def updateGateway(
      request: zio.aws.iotsitewise.model.UpdateGatewayRequest
  ): ZIO[zio.aws.iotsitewise.IoTSiteWise, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateGateway(request))
  def createPortal(request: zio.aws.iotsitewise.model.CreatePortalRequest): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.CreatePortalResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPortal(request))
  def listPortals(
      request: zio.aws.iotsitewise.model.ListPortalsRequest
  ): ZStream[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.PortalSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listPortals(request))
  def listPortalsPaginated(
      request: zio.aws.iotsitewise.model.ListPortalsRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.ListPortalsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPortalsPaginated(request))
  def deletePortal(request: zio.aws.iotsitewise.model.DeletePortalRequest): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.DeletePortalResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deletePortal(request))
  def createGateway(
      request: zio.aws.iotsitewise.model.CreateGatewayRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.CreateGatewayResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createGateway(request))
  def updateAccessPolicy(
      request: zio.aws.iotsitewise.model.UpdateAccessPolicyRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.UpdateAccessPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateAccessPolicy(request))
  def deleteAssetModel(
      request: zio.aws.iotsitewise.model.DeleteAssetModelRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.DeleteAssetModelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAssetModel(request))
  def disassociateAssets(
      request: zio.aws.iotsitewise.model.DisassociateAssetsRequest
  ): ZIO[zio.aws.iotsitewise.IoTSiteWise, AwsError, Unit] =
    ZIO.serviceWithZIO(_.disassociateAssets(request))
  def deleteGateway(
      request: zio.aws.iotsitewise.model.DeleteGatewayRequest
  ): ZIO[zio.aws.iotsitewise.IoTSiteWise, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteGateway(request))
  def updateProject(
      request: zio.aws.iotsitewise.model.UpdateProjectRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.UpdateProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateProject(request))
  def associateTimeSeriesToAssetProperty(
      request: zio.aws.iotsitewise.model.AssociateTimeSeriesToAssetPropertyRequest
  ): ZIO[zio.aws.iotsitewise.IoTSiteWise, AwsError, Unit] =
    ZIO.serviceWithZIO(_.associateTimeSeriesToAssetProperty(request))
  def batchAssociateProjectAssets(
      request: zio.aws.iotsitewise.model.BatchAssociateProjectAssetsRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.BatchAssociateProjectAssetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchAssociateProjectAssets(request))
  def createAccessPolicy(
      request: zio.aws.iotsitewise.model.CreateAccessPolicyRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.CreateAccessPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAccessPolicy(request))
  def describeLoggingOptions(
      request: zio.aws.iotsitewise.model.DescribeLoggingOptionsRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.DescribeLoggingOptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeLoggingOptions(request))
  def describeAsset(
      request: zio.aws.iotsitewise.model.DescribeAssetRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.DescribeAssetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAsset(request))
  def deleteTimeSeries(
      request: zio.aws.iotsitewise.model.DeleteTimeSeriesRequest
  ): ZIO[zio.aws.iotsitewise.IoTSiteWise, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteTimeSeries(request))
  def putStorageConfiguration(
      request: zio.aws.iotsitewise.model.PutStorageConfigurationRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.PutStorageConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putStorageConfiguration(request))
  def describeAssetModel(
      request: zio.aws.iotsitewise.model.DescribeAssetModelRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.DescribeAssetModelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAssetModel(request))
  def listAssets(request: zio.aws.iotsitewise.model.ListAssetsRequest): ZStream[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.AssetSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listAssets(request))
  def listAssetsPaginated(
      request: zio.aws.iotsitewise.model.ListAssetsRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.ListAssetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAssetsPaginated(request))
  def getInterpolatedAssetPropertyValues(
      request: zio.aws.iotsitewise.model.GetInterpolatedAssetPropertyValuesRequest
  ): ZStream[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.InterpolatedAssetPropertyValue.ReadOnly
  ] = ZStream.serviceWithStream(_.getInterpolatedAssetPropertyValues(request))
  def getInterpolatedAssetPropertyValuesPaginated(
      request: zio.aws.iotsitewise.model.GetInterpolatedAssetPropertyValuesRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.GetInterpolatedAssetPropertyValuesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getInterpolatedAssetPropertyValuesPaginated(request))
  def updateAssetModel(
      request: zio.aws.iotsitewise.model.UpdateAssetModelRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.UpdateAssetModelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateAssetModel(request))
  def listProjects(
      request: zio.aws.iotsitewise.model.ListProjectsRequest
  ): ZStream[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.ProjectSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listProjects(request))
  def listProjectsPaginated(
      request: zio.aws.iotsitewise.model.ListProjectsRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.ListProjectsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listProjectsPaginated(request))
  def putLoggingOptions(
      request: zio.aws.iotsitewise.model.PutLoggingOptionsRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.PutLoggingOptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putLoggingOptions(request))
  def deleteAccessPolicy(
      request: zio.aws.iotsitewise.model.DeleteAccessPolicyRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.DeleteAccessPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAccessPolicy(request))
  def listAssetRelationships(
      request: zio.aws.iotsitewise.model.ListAssetRelationshipsRequest
  ): ZStream[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.AssetRelationshipSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listAssetRelationships(request))
  def listAssetRelationshipsPaginated(
      request: zio.aws.iotsitewise.model.ListAssetRelationshipsRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.ListAssetRelationshipsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAssetRelationshipsPaginated(request))
  def listDashboards(
      request: zio.aws.iotsitewise.model.ListDashboardsRequest
  ): ZStream[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.DashboardSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listDashboards(request))
  def listDashboardsPaginated(
      request: zio.aws.iotsitewise.model.ListDashboardsRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.ListDashboardsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDashboardsPaginated(request))
  def updateDashboard(
      request: zio.aws.iotsitewise.model.UpdateDashboardRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.UpdateDashboardResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDashboard(request))
  def listAccessPolicies(
      request: zio.aws.iotsitewise.model.ListAccessPoliciesRequest
  ): ZStream[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.AccessPolicySummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listAccessPolicies(request))
  def listAccessPoliciesPaginated(
      request: zio.aws.iotsitewise.model.ListAccessPoliciesRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.ListAccessPoliciesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAccessPoliciesPaginated(request))
  def createDashboard(
      request: zio.aws.iotsitewise.model.CreateDashboardRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.CreateDashboardResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDashboard(request))
  def createAsset(request: zio.aws.iotsitewise.model.CreateAssetRequest): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.CreateAssetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAsset(request))
  def describeTimeSeries(
      request: zio.aws.iotsitewise.model.DescribeTimeSeriesRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.DescribeTimeSeriesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTimeSeries(request))
  def untagResource(
      request: zio.aws.iotsitewise.model.UntagResourceRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def createProject(
      request: zio.aws.iotsitewise.model.CreateProjectRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.CreateProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createProject(request))
  def describeDefaultEncryptionConfiguration(
      request: zio.aws.iotsitewise.model.DescribeDefaultEncryptionConfigurationRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.DescribeDefaultEncryptionConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDefaultEncryptionConfiguration(request))
  def describeGateway(
      request: zio.aws.iotsitewise.model.DescribeGatewayRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.DescribeGatewayResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeGateway(request))
  def getAssetPropertyValue(
      request: zio.aws.iotsitewise.model.GetAssetPropertyValueRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.GetAssetPropertyValueResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAssetPropertyValue(request))
  def putDefaultEncryptionConfiguration(
      request: zio.aws.iotsitewise.model.PutDefaultEncryptionConfigurationRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.PutDefaultEncryptionConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putDefaultEncryptionConfiguration(request))
  def describeAccessPolicy(
      request: zio.aws.iotsitewise.model.DescribeAccessPolicyRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.DescribeAccessPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAccessPolicy(request))
  def getAssetPropertyAggregates(
      request: zio.aws.iotsitewise.model.GetAssetPropertyAggregatesRequest
  ): ZStream[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.AggregatedValue.ReadOnly
  ] = ZStream.serviceWithStream(_.getAssetPropertyAggregates(request))
  def getAssetPropertyAggregatesPaginated(
      request: zio.aws.iotsitewise.model.GetAssetPropertyAggregatesRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.GetAssetPropertyAggregatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAssetPropertyAggregatesPaginated(request))
  def batchGetAssetPropertyAggregates(
      request: zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetAssetPropertyAggregates(request))
  def deleteAsset(request: zio.aws.iotsitewise.model.DeleteAssetRequest): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.DeleteAssetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAsset(request))
  def describePortal(
      request: zio.aws.iotsitewise.model.DescribePortalRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.DescribePortalResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePortal(request))
  def updatePortal(request: zio.aws.iotsitewise.model.UpdatePortalRequest): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.UpdatePortalResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updatePortal(request))
  def deleteDashboard(
      request: zio.aws.iotsitewise.model.DeleteDashboardRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.DeleteDashboardResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDashboard(request))
  def batchGetAssetPropertyValue(
      request: zio.aws.iotsitewise.model.BatchGetAssetPropertyValueRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.BatchGetAssetPropertyValueResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetAssetPropertyValue(request))
  def describeAssetProperty(
      request: zio.aws.iotsitewise.model.DescribeAssetPropertyRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.DescribeAssetPropertyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAssetProperty(request))
  def describeDashboard(
      request: zio.aws.iotsitewise.model.DescribeDashboardRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.DescribeDashboardResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDashboard(request))
  def listTagsForResource(
      request: zio.aws.iotsitewise.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def describeProject(
      request: zio.aws.iotsitewise.model.DescribeProjectRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.DescribeProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeProject(request))
  def tagResource(request: zio.aws.iotsitewise.model.TagResourceRequest): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def batchGetAssetPropertyValueHistory(
      request: zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetAssetPropertyValueHistory(request))
  def batchDisassociateProjectAssets(
      request: zio.aws.iotsitewise.model.BatchDisassociateProjectAssetsRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.BatchDisassociateProjectAssetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchDisassociateProjectAssets(request))
  def batchPutAssetPropertyValue(
      request: zio.aws.iotsitewise.model.BatchPutAssetPropertyValueRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.BatchPutAssetPropertyValueResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchPutAssetPropertyValue(request))
  def updateAsset(request: zio.aws.iotsitewise.model.UpdateAssetRequest): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.UpdateAssetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateAsset(request))
  def updateAssetProperty(
      request: zio.aws.iotsitewise.model.UpdateAssetPropertyRequest
  ): ZIO[zio.aws.iotsitewise.IoTSiteWise, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateAssetProperty(request))
  def listProjectAssets(
      request: zio.aws.iotsitewise.model.ListProjectAssetsRequest
  ): ZStream[zio.aws.iotsitewise.IoTSiteWise, AwsError, ID] =
    ZStream.serviceWithStream(_.listProjectAssets(request))
  def listProjectAssetsPaginated(
      request: zio.aws.iotsitewise.model.ListProjectAssetsRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.ListProjectAssetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listProjectAssetsPaginated(request))
  def deleteProject(
      request: zio.aws.iotsitewise.model.DeleteProjectRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.DeleteProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteProject(request))
  def listAssociatedAssets(
      request: zio.aws.iotsitewise.model.ListAssociatedAssetsRequest
  ): ZStream[zio.aws.iotsitewise.IoTSiteWise, AwsError, ReadOnly] =
    ZStream.serviceWithStream(_.listAssociatedAssets(request))
  def listAssociatedAssetsPaginated(
      request: zio.aws.iotsitewise.model.ListAssociatedAssetsRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.ListAssociatedAssetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAssociatedAssetsPaginated(request))
  def disassociateTimeSeriesFromAssetProperty(
      request: zio.aws.iotsitewise.model.DisassociateTimeSeriesFromAssetPropertyRequest
  ): ZIO[zio.aws.iotsitewise.IoTSiteWise, AwsError, Unit] =
    ZIO.serviceWithZIO(_.disassociateTimeSeriesFromAssetProperty(request))
  def createAssetModel(
      request: zio.aws.iotsitewise.model.CreateAssetModelRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.CreateAssetModelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAssetModel(request))
  def describeGatewayCapabilityConfiguration(
      request: zio.aws.iotsitewise.model.DescribeGatewayCapabilityConfigurationRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.DescribeGatewayCapabilityConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeGatewayCapabilityConfiguration(request))
  def updateGatewayCapabilityConfiguration(
      request: zio.aws.iotsitewise.model.UpdateGatewayCapabilityConfigurationRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.UpdateGatewayCapabilityConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateGatewayCapabilityConfiguration(request))
  def describeStorageConfiguration(
      request: zio.aws.iotsitewise.model.DescribeStorageConfigurationRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.DescribeStorageConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeStorageConfiguration(request))
  def listAssetModels(
      request: zio.aws.iotsitewise.model.ListAssetModelsRequest
  ): ZStream[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.AssetModelSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listAssetModels(request))
  def listAssetModelsPaginated(
      request: zio.aws.iotsitewise.model.ListAssetModelsRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.ListAssetModelsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAssetModelsPaginated(request))
  def listGateways(
      request: zio.aws.iotsitewise.model.ListGatewaysRequest
  ): ZStream[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.GatewaySummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listGateways(request))
  def listGatewaysPaginated(
      request: zio.aws.iotsitewise.model.ListGatewaysRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.ListGatewaysResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listGatewaysPaginated(request))
  def listTimeSeries(
      request: zio.aws.iotsitewise.model.ListTimeSeriesRequest
  ): ZStream[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.TimeSeriesSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listTimeSeries(request))
  def listTimeSeriesPaginated(
      request: zio.aws.iotsitewise.model.ListTimeSeriesRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.ListTimeSeriesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTimeSeriesPaginated(request))
  def getAssetPropertyValueHistory(
      request: zio.aws.iotsitewise.model.GetAssetPropertyValueHistoryRequest
  ): ZStream[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.AssetPropertyValue.ReadOnly
  ] = ZStream.serviceWithStream(_.getAssetPropertyValueHistory(request))
  def getAssetPropertyValueHistoryPaginated(
      request: zio.aws.iotsitewise.model.GetAssetPropertyValueHistoryRequest
  ): ZIO[
    zio.aws.iotsitewise.IoTSiteWise,
    AwsError,
    zio.aws.iotsitewise.model.GetAssetPropertyValueHistoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAssetPropertyValueHistoryPaginated(request))
}
