package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.ID
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeDashboardRequest(dashboardId: ID) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.DescribeDashboardRequest = {
    import DescribeDashboardRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.DescribeDashboardRequest
      .builder()
      .dashboardId(ID.unwrap(dashboardId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.DescribeDashboardRequest.ReadOnly =
    zio.aws.iotsitewise.model.DescribeDashboardRequest.wrap(buildAwsValue())
}
object DescribeDashboardRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.DescribeDashboardRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.DescribeDashboardRequest =
      zio.aws.iotsitewise.model.DescribeDashboardRequest(dashboardId)
    def dashboardId: ID
    def getDashboardId: ZIO[Any, Nothing, ID] = ZIO.succeed(dashboardId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeDashboardRequest
  ) extends zio.aws.iotsitewise.model.DescribeDashboardRequest.ReadOnly {
    override val dashboardId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.dashboardId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeDashboardRequest
  ): zio.aws.iotsitewise.model.DescribeDashboardRequest.ReadOnly = new Wrapper(
    impl
  )
}
