package zio.aws.iotsitewise
import zio.aws.iotsitewise.model.AssociatedAssetsSummary.ReadOnly
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseAsyncClient
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.iotsitewise.model.primitives.ID
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.iotsitewise.model.{
  DeleteGatewayRequest,
  DeleteAssetRequest,
  DescribeLoggingOptionsRequest,
  DescribeStorageConfigurationRequest,
  GetAssetPropertyAggregatesRequest,
  DescribeGatewayRequest,
  CreateAccessPolicyRequest,
  CreateProjectRequest,
  ListPortalsRequest,
  ListDashboardsRequest,
  ListTimeSeriesRequest,
  GetAssetPropertyValueHistoryRequest,
  DeleteAssetModelRequest,
  DescribeTimeSeriesRequest,
  DeleteAccessPolicyRequest,
  UpdateDashboardRequest,
  ListTagsForResourceRequest,
  CreateAssetRequest,
  CreatePortalRequest,
  CreateAssetModelRequest,
  BatchGetAssetPropertyAggregatesRequest,
  UpdateGatewayRequest,
  AssociateTimeSeriesToAssetPropertyRequest,
  UpdateAssetModelRequest,
  UpdateProjectRequest,
  DeletePortalRequest,
  DeleteProjectRequest,
  DeleteTimeSeriesRequest,
  DescribeAssetPropertyRequest,
  UpdateAssetPropertyRequest,
  ListAssetModelsRequest,
  ListAssociatedAssetsRequest,
  BatchGetAssetPropertyValueRequest,
  UpdateAssetRequest,
  DescribePortalRequest,
  BatchGetAssetPropertyValueHistoryRequest,
  DescribeAccessPolicyRequest,
  DeleteDashboardRequest,
  ListAssetsRequest,
  PutLoggingOptionsRequest,
  BatchAssociateProjectAssetsRequest,
  ListProjectsRequest,
  UntagResourceRequest,
  CreateDashboardRequest,
  GetAssetPropertyValueRequest,
  DescribeAssetRequest,
  DescribeAssetModelRequest,
  CreateGatewayRequest,
  DescribeGatewayCapabilityConfigurationRequest,
  BatchPutAssetPropertyValueRequest,
  UpdateGatewayCapabilityConfigurationRequest,
  DescribeDashboardRequest,
  ListGatewaysRequest,
  UpdatePortalRequest,
  DisassociateAssetsRequest,
  BatchDisassociateProjectAssetsRequest,
  UpdateAccessPolicyRequest,
  AssociateAssetsRequest,
  DescribeProjectRequest,
  TagResourceRequest,
  GetInterpolatedAssetPropertyValuesRequest,
  PutStorageConfigurationRequest,
  DisassociateTimeSeriesFromAssetPropertyRequest,
  ListAccessPoliciesRequest,
  ListProjectAssetsRequest,
  ListAssetRelationshipsRequest,
  DescribeDefaultEncryptionConfigurationRequest,
  PutDefaultEncryptionConfigurationRequest
}
import zio.stream.ZStream
object IoTSiteWiseMock extends Mock[IoTSiteWise] {
  object AssociateAssets extends Effect[AssociateAssetsRequest, AwsError, Unit]
  object UpdateGateway extends Effect[UpdateGatewayRequest, AwsError, Unit]
  object CreatePortal
      extends Effect[
        CreatePortalRequest,
        AwsError,
        zio.aws.iotsitewise.model.CreatePortalResponse.ReadOnly
      ]
  object ListPortals
      extends Stream[
        ListPortalsRequest,
        AwsError,
        zio.aws.iotsitewise.model.PortalSummary.ReadOnly
      ]
  object ListPortalsPaginated
      extends Effect[
        ListPortalsRequest,
        AwsError,
        zio.aws.iotsitewise.model.ListPortalsResponse.ReadOnly
      ]
  object DeletePortal
      extends Effect[
        DeletePortalRequest,
        AwsError,
        zio.aws.iotsitewise.model.DeletePortalResponse.ReadOnly
      ]
  object CreateGateway
      extends Effect[
        CreateGatewayRequest,
        AwsError,
        zio.aws.iotsitewise.model.CreateGatewayResponse.ReadOnly
      ]
  object UpdateAccessPolicy
      extends Effect[
        UpdateAccessPolicyRequest,
        AwsError,
        zio.aws.iotsitewise.model.UpdateAccessPolicyResponse.ReadOnly
      ]
  object DeleteAssetModel
      extends Effect[
        DeleteAssetModelRequest,
        AwsError,
        zio.aws.iotsitewise.model.DeleteAssetModelResponse.ReadOnly
      ]
  object DisassociateAssets
      extends Effect[DisassociateAssetsRequest, AwsError, Unit]
  object DeleteGateway extends Effect[DeleteGatewayRequest, AwsError, Unit]
  object UpdateProject
      extends Effect[
        UpdateProjectRequest,
        AwsError,
        zio.aws.iotsitewise.model.UpdateProjectResponse.ReadOnly
      ]
  object AssociateTimeSeriesToAssetProperty
      extends Effect[AssociateTimeSeriesToAssetPropertyRequest, AwsError, Unit]
  object BatchAssociateProjectAssets
      extends Effect[
        BatchAssociateProjectAssetsRequest,
        AwsError,
        zio.aws.iotsitewise.model.BatchAssociateProjectAssetsResponse.ReadOnly
      ]
  object CreateAccessPolicy
      extends Effect[
        CreateAccessPolicyRequest,
        AwsError,
        zio.aws.iotsitewise.model.CreateAccessPolicyResponse.ReadOnly
      ]
  object DescribeLoggingOptions
      extends Effect[
        DescribeLoggingOptionsRequest,
        AwsError,
        zio.aws.iotsitewise.model.DescribeLoggingOptionsResponse.ReadOnly
      ]
  object DescribeAsset
      extends Effect[
        DescribeAssetRequest,
        AwsError,
        zio.aws.iotsitewise.model.DescribeAssetResponse.ReadOnly
      ]
  object DeleteTimeSeries
      extends Effect[DeleteTimeSeriesRequest, AwsError, Unit]
  object PutStorageConfiguration
      extends Effect[
        PutStorageConfigurationRequest,
        AwsError,
        zio.aws.iotsitewise.model.PutStorageConfigurationResponse.ReadOnly
      ]
  object DescribeAssetModel
      extends Effect[
        DescribeAssetModelRequest,
        AwsError,
        zio.aws.iotsitewise.model.DescribeAssetModelResponse.ReadOnly
      ]
  object ListAssets
      extends Stream[
        ListAssetsRequest,
        AwsError,
        zio.aws.iotsitewise.model.AssetSummary.ReadOnly
      ]
  object ListAssetsPaginated
      extends Effect[
        ListAssetsRequest,
        AwsError,
        zio.aws.iotsitewise.model.ListAssetsResponse.ReadOnly
      ]
  object GetInterpolatedAssetPropertyValues
      extends Stream[
        GetInterpolatedAssetPropertyValuesRequest,
        AwsError,
        zio.aws.iotsitewise.model.InterpolatedAssetPropertyValue.ReadOnly
      ]
  object GetInterpolatedAssetPropertyValuesPaginated
      extends Effect[
        GetInterpolatedAssetPropertyValuesRequest,
        AwsError,
        zio.aws.iotsitewise.model.GetInterpolatedAssetPropertyValuesResponse.ReadOnly
      ]
  object UpdateAssetModel
      extends Effect[
        UpdateAssetModelRequest,
        AwsError,
        zio.aws.iotsitewise.model.UpdateAssetModelResponse.ReadOnly
      ]
  object ListProjects
      extends Stream[
        ListProjectsRequest,
        AwsError,
        zio.aws.iotsitewise.model.ProjectSummary.ReadOnly
      ]
  object ListProjectsPaginated
      extends Effect[
        ListProjectsRequest,
        AwsError,
        zio.aws.iotsitewise.model.ListProjectsResponse.ReadOnly
      ]
  object PutLoggingOptions
      extends Effect[
        PutLoggingOptionsRequest,
        AwsError,
        zio.aws.iotsitewise.model.PutLoggingOptionsResponse.ReadOnly
      ]
  object DeleteAccessPolicy
      extends Effect[
        DeleteAccessPolicyRequest,
        AwsError,
        zio.aws.iotsitewise.model.DeleteAccessPolicyResponse.ReadOnly
      ]
  object ListAssetRelationships
      extends Stream[
        ListAssetRelationshipsRequest,
        AwsError,
        zio.aws.iotsitewise.model.AssetRelationshipSummary.ReadOnly
      ]
  object ListAssetRelationshipsPaginated
      extends Effect[
        ListAssetRelationshipsRequest,
        AwsError,
        zio.aws.iotsitewise.model.ListAssetRelationshipsResponse.ReadOnly
      ]
  object ListDashboards
      extends Stream[
        ListDashboardsRequest,
        AwsError,
        zio.aws.iotsitewise.model.DashboardSummary.ReadOnly
      ]
  object ListDashboardsPaginated
      extends Effect[
        ListDashboardsRequest,
        AwsError,
        zio.aws.iotsitewise.model.ListDashboardsResponse.ReadOnly
      ]
  object UpdateDashboard
      extends Effect[
        UpdateDashboardRequest,
        AwsError,
        zio.aws.iotsitewise.model.UpdateDashboardResponse.ReadOnly
      ]
  object ListAccessPolicies
      extends Stream[
        ListAccessPoliciesRequest,
        AwsError,
        zio.aws.iotsitewise.model.AccessPolicySummary.ReadOnly
      ]
  object ListAccessPoliciesPaginated
      extends Effect[
        ListAccessPoliciesRequest,
        AwsError,
        zio.aws.iotsitewise.model.ListAccessPoliciesResponse.ReadOnly
      ]
  object CreateDashboard
      extends Effect[
        CreateDashboardRequest,
        AwsError,
        zio.aws.iotsitewise.model.CreateDashboardResponse.ReadOnly
      ]
  object CreateAsset
      extends Effect[
        CreateAssetRequest,
        AwsError,
        zio.aws.iotsitewise.model.CreateAssetResponse.ReadOnly
      ]
  object DescribeTimeSeries
      extends Effect[
        DescribeTimeSeriesRequest,
        AwsError,
        zio.aws.iotsitewise.model.DescribeTimeSeriesResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.iotsitewise.model.UntagResourceResponse.ReadOnly
      ]
  object CreateProject
      extends Effect[
        CreateProjectRequest,
        AwsError,
        zio.aws.iotsitewise.model.CreateProjectResponse.ReadOnly
      ]
  object DescribeDefaultEncryptionConfiguration
      extends Effect[
        DescribeDefaultEncryptionConfigurationRequest,
        AwsError,
        zio.aws.iotsitewise.model.DescribeDefaultEncryptionConfigurationResponse.ReadOnly
      ]
  object DescribeGateway
      extends Effect[
        DescribeGatewayRequest,
        AwsError,
        zio.aws.iotsitewise.model.DescribeGatewayResponse.ReadOnly
      ]
  object GetAssetPropertyValue
      extends Effect[
        GetAssetPropertyValueRequest,
        AwsError,
        zio.aws.iotsitewise.model.GetAssetPropertyValueResponse.ReadOnly
      ]
  object PutDefaultEncryptionConfiguration
      extends Effect[
        PutDefaultEncryptionConfigurationRequest,
        AwsError,
        zio.aws.iotsitewise.model.PutDefaultEncryptionConfigurationResponse.ReadOnly
      ]
  object DescribeAccessPolicy
      extends Effect[
        DescribeAccessPolicyRequest,
        AwsError,
        zio.aws.iotsitewise.model.DescribeAccessPolicyResponse.ReadOnly
      ]
  object GetAssetPropertyAggregates
      extends Stream[
        GetAssetPropertyAggregatesRequest,
        AwsError,
        zio.aws.iotsitewise.model.AggregatedValue.ReadOnly
      ]
  object GetAssetPropertyAggregatesPaginated
      extends Effect[
        GetAssetPropertyAggregatesRequest,
        AwsError,
        zio.aws.iotsitewise.model.GetAssetPropertyAggregatesResponse.ReadOnly
      ]
  object BatchGetAssetPropertyAggregates
      extends Effect[
        BatchGetAssetPropertyAggregatesRequest,
        AwsError,
        zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesResponse.ReadOnly
      ]
  object DeleteAsset
      extends Effect[
        DeleteAssetRequest,
        AwsError,
        zio.aws.iotsitewise.model.DeleteAssetResponse.ReadOnly
      ]
  object DescribePortal
      extends Effect[
        DescribePortalRequest,
        AwsError,
        zio.aws.iotsitewise.model.DescribePortalResponse.ReadOnly
      ]
  object UpdatePortal
      extends Effect[
        UpdatePortalRequest,
        AwsError,
        zio.aws.iotsitewise.model.UpdatePortalResponse.ReadOnly
      ]
  object DeleteDashboard
      extends Effect[
        DeleteDashboardRequest,
        AwsError,
        zio.aws.iotsitewise.model.DeleteDashboardResponse.ReadOnly
      ]
  object BatchGetAssetPropertyValue
      extends Effect[
        BatchGetAssetPropertyValueRequest,
        AwsError,
        zio.aws.iotsitewise.model.BatchGetAssetPropertyValueResponse.ReadOnly
      ]
  object DescribeAssetProperty
      extends Effect[
        DescribeAssetPropertyRequest,
        AwsError,
        zio.aws.iotsitewise.model.DescribeAssetPropertyResponse.ReadOnly
      ]
  object DescribeDashboard
      extends Effect[
        DescribeDashboardRequest,
        AwsError,
        zio.aws.iotsitewise.model.DescribeDashboardResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.iotsitewise.model.ListTagsForResourceResponse.ReadOnly
      ]
  object DescribeProject
      extends Effect[
        DescribeProjectRequest,
        AwsError,
        zio.aws.iotsitewise.model.DescribeProjectResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.iotsitewise.model.TagResourceResponse.ReadOnly
      ]
  object BatchGetAssetPropertyValueHistory
      extends Effect[
        BatchGetAssetPropertyValueHistoryRequest,
        AwsError,
        zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryResponse.ReadOnly
      ]
  object BatchDisassociateProjectAssets
      extends Effect[
        BatchDisassociateProjectAssetsRequest,
        AwsError,
        zio.aws.iotsitewise.model.BatchDisassociateProjectAssetsResponse.ReadOnly
      ]
  object BatchPutAssetPropertyValue
      extends Effect[
        BatchPutAssetPropertyValueRequest,
        AwsError,
        zio.aws.iotsitewise.model.BatchPutAssetPropertyValueResponse.ReadOnly
      ]
  object UpdateAsset
      extends Effect[
        UpdateAssetRequest,
        AwsError,
        zio.aws.iotsitewise.model.UpdateAssetResponse.ReadOnly
      ]
  object UpdateAssetProperty
      extends Effect[UpdateAssetPropertyRequest, AwsError, Unit]
  object ListProjectAssets
      extends Stream[ListProjectAssetsRequest, AwsError, ID]
  object ListProjectAssetsPaginated
      extends Effect[
        ListProjectAssetsRequest,
        AwsError,
        zio.aws.iotsitewise.model.ListProjectAssetsResponse.ReadOnly
      ]
  object DeleteProject
      extends Effect[
        DeleteProjectRequest,
        AwsError,
        zio.aws.iotsitewise.model.DeleteProjectResponse.ReadOnly
      ]
  object ListAssociatedAssets
      extends Stream[ListAssociatedAssetsRequest, AwsError, ReadOnly]
  object ListAssociatedAssetsPaginated
      extends Effect[
        ListAssociatedAssetsRequest,
        AwsError,
        zio.aws.iotsitewise.model.ListAssociatedAssetsResponse.ReadOnly
      ]
  object DisassociateTimeSeriesFromAssetProperty
      extends Effect[
        DisassociateTimeSeriesFromAssetPropertyRequest,
        AwsError,
        Unit
      ]
  object CreateAssetModel
      extends Effect[
        CreateAssetModelRequest,
        AwsError,
        zio.aws.iotsitewise.model.CreateAssetModelResponse.ReadOnly
      ]
  object DescribeGatewayCapabilityConfiguration
      extends Effect[
        DescribeGatewayCapabilityConfigurationRequest,
        AwsError,
        zio.aws.iotsitewise.model.DescribeGatewayCapabilityConfigurationResponse.ReadOnly
      ]
  object UpdateGatewayCapabilityConfiguration
      extends Effect[
        UpdateGatewayCapabilityConfigurationRequest,
        AwsError,
        zio.aws.iotsitewise.model.UpdateGatewayCapabilityConfigurationResponse.ReadOnly
      ]
  object DescribeStorageConfiguration
      extends Effect[
        DescribeStorageConfigurationRequest,
        AwsError,
        zio.aws.iotsitewise.model.DescribeStorageConfigurationResponse.ReadOnly
      ]
  object ListAssetModels
      extends Stream[
        ListAssetModelsRequest,
        AwsError,
        zio.aws.iotsitewise.model.AssetModelSummary.ReadOnly
      ]
  object ListAssetModelsPaginated
      extends Effect[
        ListAssetModelsRequest,
        AwsError,
        zio.aws.iotsitewise.model.ListAssetModelsResponse.ReadOnly
      ]
  object ListGateways
      extends Stream[
        ListGatewaysRequest,
        AwsError,
        zio.aws.iotsitewise.model.GatewaySummary.ReadOnly
      ]
  object ListGatewaysPaginated
      extends Effect[
        ListGatewaysRequest,
        AwsError,
        zio.aws.iotsitewise.model.ListGatewaysResponse.ReadOnly
      ]
  object ListTimeSeries
      extends Stream[
        ListTimeSeriesRequest,
        AwsError,
        zio.aws.iotsitewise.model.TimeSeriesSummary.ReadOnly
      ]
  object ListTimeSeriesPaginated
      extends Effect[
        ListTimeSeriesRequest,
        AwsError,
        zio.aws.iotsitewise.model.ListTimeSeriesResponse.ReadOnly
      ]
  object GetAssetPropertyValueHistory
      extends Stream[
        GetAssetPropertyValueHistoryRequest,
        AwsError,
        zio.aws.iotsitewise.model.AssetPropertyValue.ReadOnly
      ]
  object GetAssetPropertyValueHistoryPaginated
      extends Effect[
        GetAssetPropertyValueHistoryRequest,
        AwsError,
        zio.aws.iotsitewise.model.GetAssetPropertyValueHistoryResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, IoTSiteWise] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, IoTSiteWise] { rts =>
        zio.ZIO.succeed {
          new IoTSiteWise {
            val api: IoTSiteWiseAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): IoTSiteWise = this
            def associateAssets(
                request: AssociateAssetsRequest
            ): IO[AwsError, Unit] = proxy(AssociateAssets, request)
            def updateGateway(
                request: UpdateGatewayRequest
            ): IO[AwsError, Unit] = proxy(UpdateGateway, request)
            def createPortal(request: CreatePortalRequest): IO[
              AwsError,
              zio.aws.iotsitewise.model.CreatePortalResponse.ReadOnly
            ] = proxy(CreatePortal, request)
            def listPortals(request: ListPortalsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.iotsitewise.model.PortalSummary.ReadOnly
            ] = rts.unsafeRun(proxy(ListPortals, request))
            def listPortalsPaginated(request: ListPortalsRequest): IO[
              AwsError,
              zio.aws.iotsitewise.model.ListPortalsResponse.ReadOnly
            ] = proxy(ListPortalsPaginated, request)
            def deletePortal(request: DeletePortalRequest): IO[
              AwsError,
              zio.aws.iotsitewise.model.DeletePortalResponse.ReadOnly
            ] = proxy(DeletePortal, request)
            def createGateway(request: CreateGatewayRequest): IO[
              AwsError,
              zio.aws.iotsitewise.model.CreateGatewayResponse.ReadOnly
            ] = proxy(CreateGateway, request)
            def updateAccessPolicy(request: UpdateAccessPolicyRequest): IO[
              AwsError,
              zio.aws.iotsitewise.model.UpdateAccessPolicyResponse.ReadOnly
            ] = proxy(UpdateAccessPolicy, request)
            def deleteAssetModel(request: DeleteAssetModelRequest): IO[
              AwsError,
              zio.aws.iotsitewise.model.DeleteAssetModelResponse.ReadOnly
            ] = proxy(DeleteAssetModel, request)
            def disassociateAssets(
                request: DisassociateAssetsRequest
            ): IO[AwsError, Unit] = proxy(DisassociateAssets, request)
            def deleteGateway(
                request: DeleteGatewayRequest
            ): IO[AwsError, Unit] = proxy(DeleteGateway, request)
            def updateProject(request: UpdateProjectRequest): IO[
              AwsError,
              zio.aws.iotsitewise.model.UpdateProjectResponse.ReadOnly
            ] = proxy(UpdateProject, request)
            def associateTimeSeriesToAssetProperty(
                request: AssociateTimeSeriesToAssetPropertyRequest
            ): IO[AwsError, Unit] =
              proxy(AssociateTimeSeriesToAssetProperty, request)
            def batchAssociateProjectAssets(
                request: BatchAssociateProjectAssetsRequest
            ): IO[
              AwsError,
              zio.aws.iotsitewise.model.BatchAssociateProjectAssetsResponse.ReadOnly
            ] = proxy(BatchAssociateProjectAssets, request)
            def createAccessPolicy(request: CreateAccessPolicyRequest): IO[
              AwsError,
              zio.aws.iotsitewise.model.CreateAccessPolicyResponse.ReadOnly
            ] = proxy(CreateAccessPolicy, request)
            def describeLoggingOptions(
                request: DescribeLoggingOptionsRequest
            ): IO[
              AwsError,
              zio.aws.iotsitewise.model.DescribeLoggingOptionsResponse.ReadOnly
            ] = proxy(DescribeLoggingOptions, request)
            def describeAsset(request: DescribeAssetRequest): IO[
              AwsError,
              zio.aws.iotsitewise.model.DescribeAssetResponse.ReadOnly
            ] = proxy(DescribeAsset, request)
            def deleteTimeSeries(
                request: DeleteTimeSeriesRequest
            ): IO[AwsError, Unit] = proxy(DeleteTimeSeries, request)
            def putStorageConfiguration(
                request: PutStorageConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.iotsitewise.model.PutStorageConfigurationResponse.ReadOnly
            ] = proxy(PutStorageConfiguration, request)
            def describeAssetModel(request: DescribeAssetModelRequest): IO[
              AwsError,
              zio.aws.iotsitewise.model.DescribeAssetModelResponse.ReadOnly
            ] = proxy(DescribeAssetModel, request)
            def listAssets(request: ListAssetsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.iotsitewise.model.AssetSummary.ReadOnly
            ] = rts.unsafeRun(proxy(ListAssets, request))
            def listAssetsPaginated(request: ListAssetsRequest): IO[
              AwsError,
              zio.aws.iotsitewise.model.ListAssetsResponse.ReadOnly
            ] = proxy(ListAssetsPaginated, request)
            def getInterpolatedAssetPropertyValues(
                request: GetInterpolatedAssetPropertyValuesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.iotsitewise.model.InterpolatedAssetPropertyValue.ReadOnly
            ] =
              rts.unsafeRun(proxy(GetInterpolatedAssetPropertyValues, request))
            def getInterpolatedAssetPropertyValuesPaginated(
                request: GetInterpolatedAssetPropertyValuesRequest
            ): IO[
              AwsError,
              zio.aws.iotsitewise.model.GetInterpolatedAssetPropertyValuesResponse.ReadOnly
            ] = proxy(GetInterpolatedAssetPropertyValuesPaginated, request)
            def updateAssetModel(request: UpdateAssetModelRequest): IO[
              AwsError,
              zio.aws.iotsitewise.model.UpdateAssetModelResponse.ReadOnly
            ] = proxy(UpdateAssetModel, request)
            def listProjects(request: ListProjectsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.iotsitewise.model.ProjectSummary.ReadOnly
            ] = rts.unsafeRun(proxy(ListProjects, request))
            def listProjectsPaginated(request: ListProjectsRequest): IO[
              AwsError,
              zio.aws.iotsitewise.model.ListProjectsResponse.ReadOnly
            ] = proxy(ListProjectsPaginated, request)
            def putLoggingOptions(request: PutLoggingOptionsRequest): IO[
              AwsError,
              zio.aws.iotsitewise.model.PutLoggingOptionsResponse.ReadOnly
            ] = proxy(PutLoggingOptions, request)
            def deleteAccessPolicy(request: DeleteAccessPolicyRequest): IO[
              AwsError,
              zio.aws.iotsitewise.model.DeleteAccessPolicyResponse.ReadOnly
            ] = proxy(DeleteAccessPolicy, request)
            def listAssetRelationships(
                request: ListAssetRelationshipsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.iotsitewise.model.AssetRelationshipSummary.ReadOnly
            ] = rts.unsafeRun(proxy(ListAssetRelationships, request))
            def listAssetRelationshipsPaginated(
                request: ListAssetRelationshipsRequest
            ): IO[
              AwsError,
              zio.aws.iotsitewise.model.ListAssetRelationshipsResponse.ReadOnly
            ] = proxy(ListAssetRelationshipsPaginated, request)
            def listDashboards(request: ListDashboardsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.iotsitewise.model.DashboardSummary.ReadOnly
            ] = rts.unsafeRun(proxy(ListDashboards, request))
            def listDashboardsPaginated(request: ListDashboardsRequest): IO[
              AwsError,
              zio.aws.iotsitewise.model.ListDashboardsResponse.ReadOnly
            ] = proxy(ListDashboardsPaginated, request)
            def updateDashboard(request: UpdateDashboardRequest): IO[
              AwsError,
              zio.aws.iotsitewise.model.UpdateDashboardResponse.ReadOnly
            ] = proxy(UpdateDashboard, request)
            def listAccessPolicies(request: ListAccessPoliciesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.iotsitewise.model.AccessPolicySummary.ReadOnly
            ] = rts.unsafeRun(proxy(ListAccessPolicies, request))
            def listAccessPoliciesPaginated(
                request: ListAccessPoliciesRequest
            ): IO[
              AwsError,
              zio.aws.iotsitewise.model.ListAccessPoliciesResponse.ReadOnly
            ] = proxy(ListAccessPoliciesPaginated, request)
            def createDashboard(request: CreateDashboardRequest): IO[
              AwsError,
              zio.aws.iotsitewise.model.CreateDashboardResponse.ReadOnly
            ] = proxy(CreateDashboard, request)
            def createAsset(request: CreateAssetRequest): IO[
              AwsError,
              zio.aws.iotsitewise.model.CreateAssetResponse.ReadOnly
            ] = proxy(CreateAsset, request)
            def describeTimeSeries(request: DescribeTimeSeriesRequest): IO[
              AwsError,
              zio.aws.iotsitewise.model.DescribeTimeSeriesResponse.ReadOnly
            ] = proxy(DescribeTimeSeries, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.iotsitewise.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def createProject(request: CreateProjectRequest): IO[
              AwsError,
              zio.aws.iotsitewise.model.CreateProjectResponse.ReadOnly
            ] = proxy(CreateProject, request)
            def describeDefaultEncryptionConfiguration(
                request: DescribeDefaultEncryptionConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.iotsitewise.model.DescribeDefaultEncryptionConfigurationResponse.ReadOnly
            ] = proxy(DescribeDefaultEncryptionConfiguration, request)
            def describeGateway(request: DescribeGatewayRequest): IO[
              AwsError,
              zio.aws.iotsitewise.model.DescribeGatewayResponse.ReadOnly
            ] = proxy(DescribeGateway, request)
            def getAssetPropertyValue(
                request: GetAssetPropertyValueRequest
            ): IO[
              AwsError,
              zio.aws.iotsitewise.model.GetAssetPropertyValueResponse.ReadOnly
            ] = proxy(GetAssetPropertyValue, request)
            def putDefaultEncryptionConfiguration(
                request: PutDefaultEncryptionConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.iotsitewise.model.PutDefaultEncryptionConfigurationResponse.ReadOnly
            ] = proxy(PutDefaultEncryptionConfiguration, request)
            def describeAccessPolicy(request: DescribeAccessPolicyRequest): IO[
              AwsError,
              zio.aws.iotsitewise.model.DescribeAccessPolicyResponse.ReadOnly
            ] = proxy(DescribeAccessPolicy, request)
            def getAssetPropertyAggregates(
                request: GetAssetPropertyAggregatesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.iotsitewise.model.AggregatedValue.ReadOnly
            ] = rts.unsafeRun(proxy(GetAssetPropertyAggregates, request))
            def getAssetPropertyAggregatesPaginated(
                request: GetAssetPropertyAggregatesRequest
            ): IO[
              AwsError,
              zio.aws.iotsitewise.model.GetAssetPropertyAggregatesResponse.ReadOnly
            ] = proxy(GetAssetPropertyAggregatesPaginated, request)
            def batchGetAssetPropertyAggregates(
                request: BatchGetAssetPropertyAggregatesRequest
            ): IO[
              AwsError,
              zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesResponse.ReadOnly
            ] = proxy(BatchGetAssetPropertyAggregates, request)
            def deleteAsset(request: DeleteAssetRequest): IO[
              AwsError,
              zio.aws.iotsitewise.model.DeleteAssetResponse.ReadOnly
            ] = proxy(DeleteAsset, request)
            def describePortal(request: DescribePortalRequest): IO[
              AwsError,
              zio.aws.iotsitewise.model.DescribePortalResponse.ReadOnly
            ] = proxy(DescribePortal, request)
            def updatePortal(request: UpdatePortalRequest): IO[
              AwsError,
              zio.aws.iotsitewise.model.UpdatePortalResponse.ReadOnly
            ] = proxy(UpdatePortal, request)
            def deleteDashboard(request: DeleteDashboardRequest): IO[
              AwsError,
              zio.aws.iotsitewise.model.DeleteDashboardResponse.ReadOnly
            ] = proxy(DeleteDashboard, request)
            def batchGetAssetPropertyValue(
                request: BatchGetAssetPropertyValueRequest
            ): IO[
              AwsError,
              zio.aws.iotsitewise.model.BatchGetAssetPropertyValueResponse.ReadOnly
            ] = proxy(BatchGetAssetPropertyValue, request)
            def describeAssetProperty(
                request: DescribeAssetPropertyRequest
            ): IO[
              AwsError,
              zio.aws.iotsitewise.model.DescribeAssetPropertyResponse.ReadOnly
            ] = proxy(DescribeAssetProperty, request)
            def describeDashboard(request: DescribeDashboardRequest): IO[
              AwsError,
              zio.aws.iotsitewise.model.DescribeDashboardResponse.ReadOnly
            ] = proxy(DescribeDashboard, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.iotsitewise.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def describeProject(request: DescribeProjectRequest): IO[
              AwsError,
              zio.aws.iotsitewise.model.DescribeProjectResponse.ReadOnly
            ] = proxy(DescribeProject, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.iotsitewise.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def batchGetAssetPropertyValueHistory(
                request: BatchGetAssetPropertyValueHistoryRequest
            ): IO[
              AwsError,
              zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryResponse.ReadOnly
            ] = proxy(BatchGetAssetPropertyValueHistory, request)
            def batchDisassociateProjectAssets(
                request: BatchDisassociateProjectAssetsRequest
            ): IO[
              AwsError,
              zio.aws.iotsitewise.model.BatchDisassociateProjectAssetsResponse.ReadOnly
            ] = proxy(BatchDisassociateProjectAssets, request)
            def batchPutAssetPropertyValue(
                request: BatchPutAssetPropertyValueRequest
            ): IO[
              AwsError,
              zio.aws.iotsitewise.model.BatchPutAssetPropertyValueResponse.ReadOnly
            ] = proxy(BatchPutAssetPropertyValue, request)
            def updateAsset(request: UpdateAssetRequest): IO[
              AwsError,
              zio.aws.iotsitewise.model.UpdateAssetResponse.ReadOnly
            ] = proxy(UpdateAsset, request)
            def updateAssetProperty(
                request: UpdateAssetPropertyRequest
            ): IO[AwsError, Unit] = proxy(UpdateAssetProperty, request)
            def listProjectAssets(
                request: ListProjectAssetsRequest
            ): ZStream[Any, AwsError, ID] =
              rts.unsafeRun(proxy(ListProjectAssets, request))
            def listProjectAssetsPaginated(
                request: ListProjectAssetsRequest
            ): IO[
              AwsError,
              zio.aws.iotsitewise.model.ListProjectAssetsResponse.ReadOnly
            ] = proxy(ListProjectAssetsPaginated, request)
            def deleteProject(request: DeleteProjectRequest): IO[
              AwsError,
              zio.aws.iotsitewise.model.DeleteProjectResponse.ReadOnly
            ] = proxy(DeleteProject, request)
            def listAssociatedAssets(
                request: ListAssociatedAssetsRequest
            ): ZStream[Any, AwsError, ReadOnly] =
              rts.unsafeRun(proxy(ListAssociatedAssets, request))
            def listAssociatedAssetsPaginated(
                request: ListAssociatedAssetsRequest
            ): IO[
              AwsError,
              zio.aws.iotsitewise.model.ListAssociatedAssetsResponse.ReadOnly
            ] = proxy(ListAssociatedAssetsPaginated, request)
            def disassociateTimeSeriesFromAssetProperty(
                request: DisassociateTimeSeriesFromAssetPropertyRequest
            ): IO[AwsError, Unit] =
              proxy(DisassociateTimeSeriesFromAssetProperty, request)
            def createAssetModel(request: CreateAssetModelRequest): IO[
              AwsError,
              zio.aws.iotsitewise.model.CreateAssetModelResponse.ReadOnly
            ] = proxy(CreateAssetModel, request)
            def describeGatewayCapabilityConfiguration(
                request: DescribeGatewayCapabilityConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.iotsitewise.model.DescribeGatewayCapabilityConfigurationResponse.ReadOnly
            ] = proxy(DescribeGatewayCapabilityConfiguration, request)
            def updateGatewayCapabilityConfiguration(
                request: UpdateGatewayCapabilityConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.iotsitewise.model.UpdateGatewayCapabilityConfigurationResponse.ReadOnly
            ] = proxy(UpdateGatewayCapabilityConfiguration, request)
            def describeStorageConfiguration(
                request: DescribeStorageConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.iotsitewise.model.DescribeStorageConfigurationResponse.ReadOnly
            ] = proxy(DescribeStorageConfiguration, request)
            def listAssetModels(request: ListAssetModelsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.iotsitewise.model.AssetModelSummary.ReadOnly
            ] = rts.unsafeRun(proxy(ListAssetModels, request))
            def listAssetModelsPaginated(request: ListAssetModelsRequest): IO[
              AwsError,
              zio.aws.iotsitewise.model.ListAssetModelsResponse.ReadOnly
            ] = proxy(ListAssetModelsPaginated, request)
            def listGateways(request: ListGatewaysRequest): ZStream[
              Any,
              AwsError,
              zio.aws.iotsitewise.model.GatewaySummary.ReadOnly
            ] = rts.unsafeRun(proxy(ListGateways, request))
            def listGatewaysPaginated(request: ListGatewaysRequest): IO[
              AwsError,
              zio.aws.iotsitewise.model.ListGatewaysResponse.ReadOnly
            ] = proxy(ListGatewaysPaginated, request)
            def listTimeSeries(request: ListTimeSeriesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.iotsitewise.model.TimeSeriesSummary.ReadOnly
            ] = rts.unsafeRun(proxy(ListTimeSeries, request))
            def listTimeSeriesPaginated(request: ListTimeSeriesRequest): IO[
              AwsError,
              zio.aws.iotsitewise.model.ListTimeSeriesResponse.ReadOnly
            ] = proxy(ListTimeSeriesPaginated, request)
            def getAssetPropertyValueHistory(
                request: GetAssetPropertyValueHistoryRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.iotsitewise.model.AssetPropertyValue.ReadOnly
            ] = rts.unsafeRun(proxy(GetAssetPropertyValueHistory, request))
            def getAssetPropertyValueHistoryPaginated(
                request: GetAssetPropertyValueHistoryRequest
            ): IO[
              AwsError,
              zio.aws.iotsitewise.model.GetAssetPropertyValueHistoryResponse.ReadOnly
            ] = proxy(GetAssetPropertyValueHistoryPaginated, request)
          }
        }
      }
    }
  }
}
